/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.util.NestedRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class URLLoaderBase
implements EntityResolver {
    public static final String CACHE_INDEX_FILE_NAME = "index.properties";
    public static final String CACHED_FILE_EXTENSION = ".cached";
    private Stack stack = new Stack();
    private URL stackTop = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private boolean useProxy = false;
    private String cacheDirName = null;
    private File cacheDir = null;
    private String cacheIndexFileName = null;
    private File cacheIndexFile = null;
    private boolean useCache = false;
    private Properties cacheIndex = new Properties();
    private byte[] buffer = new byte[1000];
    private static String workDir = null;
    private static char[] gHexChs;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static boolean[] gNeedEscaping;

    static {
        try {
            workDir = String.valueOf(new File("").getAbsolutePath().toString()) + "/";
        }
        catch (Exception exception) {}
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gNeedEscaping = new boolean[128];
        int i = 0;
        while (i <= 31) {
            URLLoaderBase.gNeedEscaping[i] = true;
            URLLoaderBase.gAfterEscaping1[i] = gHexChs[i >> 4];
            URLLoaderBase.gAfterEscaping2[i] = gHexChs[i & 0xF];
            ++i;
        }
        URLLoaderBase.gNeedEscaping[127] = true;
        URLLoaderBase.gAfterEscaping1[127] = 55;
        URLLoaderBase.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            URLLoaderBase.gNeedEscaping[ch] = true;
            URLLoaderBase.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            URLLoaderBase.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
            ++i2;
        }
    }

    public URLLoaderBase() {
        this.init();
    }

    public void init() {
        this.stack.clear();
        this.stackTop = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.useProxy = false;
        this.cacheDirName = null;
        this.cacheDir = null;
        this.cacheIndexFileName = null;
        this.cacheIndexFile = null;
        this.useCache = false;
        try {
            this.loadAndPush(workDir);
        }
        catch (Exception exception) {}
    }

    public URL load(String s) throws IOException {
        URL url = this.load(this.stackTop, s);
        return url;
    }

    public URL loadAndPush(String s) throws IOException {
        URL url = this.loadAndPush(this.stackTop, s);
        return url;
    }

    public URL load(URL base, String s) throws IOException {
        URL url = URLLoaderBase.fileOrURLToURL(base, s);
        if (this.useCache) {
            url = this.passThroughCache(url);
        } else if (this.useProxy) {
            url = this.passThroughProxy(url);
        }
        return url;
    }

    public URL loadAndPush(URL base, String s) throws IOException {
        URL url = URLLoaderBase.fileOrURLToURL(base, s);
        this.push(url);
        if (this.useCache) {
            url = this.passThroughCache(url);
        } else if (this.useProxy) {
            url = this.passThroughProxy(url);
        }
        return url;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream urlStream;
        InputSource is;
        block4: {
            URL external = this.loadAndPush(systemId);
            String externalURLString = external.toString();
            if (!externalURLString.startsWith("http://localhost/") || !externalURLString.substring(17).equals(systemId)) {
                systemId = external.toString();
            }
            is = new InputSource();
            is.setSystemId(systemId);
            is.setPublicId(publicId);
            try {
                urlStream = new URL(systemId).openStream();
            }
            catch (IOException ioe) {
                ClassLoader loader;
                if (systemId.startsWith("http://localhost/")) {
                    systemId = systemId.substring(17);
                }
                if ((urlStream = (loader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(systemId)) != null) break block4;
                throw new IOException("Failed to load resource from the context classloader of the current thread! Loading from classloader was caused by: " + ioe.toString());
            }
        }
        is.setByteStream(urlStream);
        return is;
    }

    public void push(URL url) {
        this.stack.push(url);
        this.stackTop = url;
    }

    public void pushTheSame() {
        try {
            this.stack.push(this.stack.peek());
        }
        catch (EmptyStackException emptyStackException) {
            this.stack.push(null);
        }
    }

    public void pop() {
        try {
            URL cfr_ignored_0 = (URL)this.stack.pop();
            this.stackTop = !this.stack.empty() ? (URL)this.stack.peek() : null;
        }
        catch (EmptyStackException emptyStackException) {
            throw new RuntimeException("URLLoader's stack is empty.");
        }
    }

    public URL peek() {
        try {
            return (URL)this.stack.peek();
        }
        catch (EmptyStackException e) {
            throw new NestedRuntimeException("URLLoader's stack is empty.", e);
        }
    }

    private URL passThroughProxy(URL url) throws IOException {
        return url;
    }

    private URL passThroughCache(URL url) throws IOException {
        int b;
        if (!this.useCache || !url.getProtocol().equals("http")) {
            return url;
        }
        String externalForm = url.toExternalForm();
        String s = this.cacheIndex.getProperty(externalForm);
        if (s != null) {
            return new URL("file:" + this.cacheDirName + "\\" + s);
        }
        s = this.createCachedFileName(url);
        url = this.passThroughProxy(url);
        InputStream in = url.openStream();
        new File(String.valueOf(this.cacheDirName) + "\\" + s).createNewFile();
        FileOutputStream out = new FileOutputStream(String.valueOf(this.cacheDirName) + "\\" + s);
        while ((b = in.read(this.buffer)) != -1) {
            out.write(this.buffer, 0, b);
        }
        out.close();
        this.cacheIndex.setProperty(externalForm, s);
        this.storeIndex();
        url = new URL("file:" + this.cacheDirName + "\\" + s);
        return url;
    }

    private String createCachedFileName(URL url) {
        String s = "_" + url.toExternalForm().replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('~', '_').replace('#', '_');
        return "t" + System.currentTimeMillis() + s + CACHED_FILE_EXTENSION;
    }

    public void storeIndex() throws IOException {
        if (this.cacheIndexFile != null) {
            if (!this.cacheIndexFile.exists()) {
                File parentDir = this.cacheIndexFile.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                this.cacheIndexFile.createNewFile();
            }
            this.cacheIndex.store(new FileOutputStream(this.cacheIndexFileName), "Index file for the caching system of the XML parser.");
        }
    }

    public void setProxyHost(String s) {
        this.proxyHost = s;
    }

    public void setProxyPort(int p) {
        this.proxyPort = p;
    }

    public void setUseProxy(boolean b) {
        this.useProxy = b;
    }

    public void setCacheDir(String s) {
        if (s.startsWith("file:")) {
            s = s.substring(5);
        }
        this.cacheDirName = s;
        this.cacheDir = new File(s);
        this.cacheIndexFile = new File(this.cacheDir, CACHE_INDEX_FILE_NAME);
        this.cacheIndexFileName = this.cacheIndexFile.toString();
        this.cacheIndex.clear();
        try {
            this.cacheIndex.load(new FileInputStream(this.cacheIndexFileName));
        }
        catch (Exception exception) {}
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public String getCacheDir() {
        return this.cacheDirName;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void printStack() {
        LogWriter.getSystemLogWriter().println("URLLoader stack = " + this.stack);
    }

    public void clearStack() {
        this.stack.clear();
    }

    public static URL fileOrURLToURL(URL base, String s) throws IOException {
        if (s == null) {
            return null;
        }
        if (base == null) {
            base = new URL("file:");
        }
        s = s.replace('\\', '/');
        try {
            String protocol = base.getProtocol();
            if (!("http".equals(protocol) || "https".equals(protocol) || s.charAt(1) != ':' && s.charAt(0) != '/' && s.charAt(0) != '\\')) {
                File file = new File(s);
                s = file.toURI().toURL().toExternalForm();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (s.startsWith("file:") && s.length() > 5 && s.charAt(5) != '/') {
            s = "file:/".concat(s.substring(5));
        } else if (s.startsWith("file://") && !s.startsWith("file:////") && !s.startsWith("file://localhost/")) {
            s = "file:////".concat(s.substring("file://".length()));
        }
        URL url = new URL(base, s);
        return url;
    }

    public static boolean isFileURL(String urlString) throws MalformedURLException {
        try {
            return URLLoaderBase.isFileURL(new URL(urlString));
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
    }

    public static boolean isFileURL(URL url) {
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        return protocol != null && (protocol.equalsIgnoreCase("jar") || protocol.equalsIgnoreCase("file"));
    }

    public static String decodeFileURL(String fileURL) throws MalformedURLException {
        if (URLLoaderBase.isFileURL(fileURL)) {
            return URLLoaderBase.decode(fileURL);
        }
        return fileURL;
    }

    public static File fileURLToFile(URL url) {
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            String file = url.getFile();
            try {
                url = new URL(file);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String host = url.getHost();
        String urlFile = host != null && !host.equals("") && !host.equals("localhost") ? "//" + host + url.getPath() : url.getFile();
        return new File(URLLoaderBase.decode(urlFile));
    }

    private static String decode(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c;
            block11: {
                c = s.charAt(i);
                if (c == '+') {
                    c = ' ';
                    ++i;
                } else if (c != '%') {
                    ++i;
                } else {
                    try {
                        c = URLLoaderBase.unescape(s, i);
                        i += 3;
                        if ((c & 0x80) == 0) break block11;
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c1 = URLLoaderBase.unescape(s, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLLoaderBase.unescape(s, i);
                                char c3 = URLLoaderBase.unescape(s, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                }
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    public static URI urlPathToURI(String urlString) throws URISyntaxException {
        if (URLLoaderBase.isURLEncoded(urlString)) {
            urlString = URLDecoder.decode(urlString);
        }
        String encodedUrlString = URLLoaderBase.escapeNonUSAscii(urlString);
        return new URI(encodedUrlString);
    }

    protected static String escapeNonUSAscii(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
        int len = bytes.length;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (b < 0) {
                int ch = b + 256;
                buffer.append('%');
                buffer.append(gHexChs[ch >> 4]);
                buffer.append(gHexChs[ch & 0xF]);
            } else if (b != 37 && b != 35 && gNeedEscaping[b]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[b]);
                buffer.append(gAfterEscaping2[b]);
            } else {
                buffer.append((char)b);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String urlEncodeSkipSlash(String url) {
        String urlMod = url.replace('\\', '/');
        String uriSeparator = "/";
        StringTokenizer tokenizer = new StringTokenizer(urlMod, uriSeparator);
        StringBuffer result = new StringBuffer(urlMod.length());
        if (urlMod.charAt(0) == '/') {
            result.append("/");
        }
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String encodedToken = URLEncoder.encode(token, "UTF-8");
                encodedToken = encodedToken.replace("+", "%20");
                result.append(encodedToken);
                if (!tokenizer.hasMoreElements()) continue;
                result.append(uriSeparator);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return url;
        }
        return result.toString();
    }

    public static boolean isURLEncoded(String urlString) {
        int percentPos = urlString.indexOf(37);
        int plusPos = urlString.indexOf(43);
        if (percentPos > -1) {
            if (percentPos + 2 >= urlString.length()) {
                return plusPos > -1;
            }
            return URLLoaderBase.isHex(urlString.charAt(percentPos + 1)) && URLLoaderBase.isHex(urlString.charAt(percentPos + 2));
        }
        return plusPos > -1;
    }

    private static boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }
}

