/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.pools;

import com.sap.engine.lib.xml.parser.binary.common.MappingData;
import com.sap.engine.lib.xml.parser.helpers.CharArray;

public final class MappingDataPool {
    private int initialSize;
    private int resizeStep = 100;
    public int pos;
    private MappingData[] arrayOfObjects;

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public MappingDataPool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new MappingData[this.initialSize];
        this.pos = this.initialSize - 1;
    }

    public MappingData getObject(CharArray prefix, CharArray uri) {
        if (this.pos < 0) {
            this.autoResize();
        }
        if (this.arrayOfObjects[this.pos] == null) {
            this.arrayOfObjects[this.pos] = new MappingData();
        }
        this.arrayOfObjects[this.pos].prefix = prefix;
        this.arrayOfObjects[this.pos].uri = uri;
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(MappingData obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
    }

    public void releaseAllObjects() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public void forceShrink() {
        int usedElements = this.arrayOfObjects.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfObjects = new MappingData[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfObjects.length != this.initialSize) {
            MappingData[] tempArr = new MappingData[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new MappingData();
                    ++i;
                }
            }
            this.arrayOfObjects = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        MappingData[] tempArr = new MappingData[this.arrayOfObjects.length + this.resizeStep];
        System.arraycopy(this.arrayOfObjects, 0, tempArr, this.resizeStep, this.arrayOfObjects.length);
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
        this.resizeStep *= 2;
    }

    public void check() throws Exception {
        int i = 0;
        while (i < this.arrayOfObjects.length) {
            int j = i + 1;
            while (j < this.arrayOfObjects.length) {
                if (this.arrayOfObjects[i] == this.arrayOfObjects[j]) {
                    throw new Exception("they are equal:" + i + "," + j + " " + this.arrayOfObjects[i] + ", " + this.arrayOfObjects[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void forceResize(int newsize) {
        MappingData[] tempArr = new MappingData[newsize];
        int count = this.arrayOfObjects.length - this.pos - 1;
        int tindex = newsize - count;
        System.arraycopy(this.arrayOfObjects, 0, tempArr, tindex, count);
        this.arrayOfObjects = tempArr;
        this.pos = newsize - count - 1;
    }

    public int getSize() {
        return this.arrayOfObjects.length;
    }
}

