/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.dtd;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.dtd.DTDElement;
import com.sap.engine.lib.xml.parser.dtd.Model;
import com.sap.engine.lib.xml.parser.dtd.State;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.HashSet;

final class Automaton {
    DTDElement owner = null;
    State initialState = null;
    State finalState = null;

    Automaton(State initialState, State finalState) {
        this.initialState = initialState;
        this.finalState = finalState;
    }

    Automaton(CharArray name) {
        this.initialState = new State(name);
        this.initialState.next1 = this.finalState = new State();
    }

    Automaton(Automaton a, Automaton b, char op) throws ValidationException {
        if (op == '|') {
            State x = new State();
            x.next1 = a.initialState;
            x.next2 = b.initialState;
            a.finalState.next1 = b.finalState;
            this.initialState = x;
            this.finalState = b.finalState;
        } else if (op == ',') {
            a.finalState.next1 = b.initialState;
            this.initialState = a.initialState;
            this.finalState = b.finalState;
        } else {
            throw new ValidationException("Illegal parameter in constructor of Automaton, '" + op + "'.");
        }
    }

    Automaton(Automaton a, char op) throws ValidationException {
        if (op == '?') {
            State x = new State();
            x.next1 = a.initialState;
            x.next2 = a.finalState;
            this.initialState = x;
            this.finalState = a.finalState;
        } else if (op == '*') {
            State x;
            this.initialState = a.finalState;
            this.initialState.next1 = a.initialState;
            this.initialState.next2 = x = new State();
            this.finalState = x;
        } else if (op == '+') {
            State x;
            a.finalState.next1 = a.initialState;
            a.finalState.next2 = x = new State();
            this.initialState = a.initialState;
            this.finalState = x;
        } else {
            throw new ValidationException("Illegal parameter in constructor of Automaton, '" + op + "'.");
        }
    }

    void print() {
        LogWriter.getSystemLogWriter().println("--- AUTOMATON ---");
        this.initialState.print(0);
    }

    static Automaton getAutomaton(XMLValidator validator, DTDElement owner, CharArray ca) throws ValidationException {
        Model model = new Model(validator, ca);
        Automaton ret = Automaton.build(validator, model);
        model.skipOptionalWhitespace();
        model.confirmEndOfModel();
        ret.finalState.name = State.FINAL_STATE;
        ret.owner = owner;
        return ret;
    }

    private static Automaton build(XMLValidator validator, Model model) throws ValidationException {
        model.skipOptionalWhitespace();
        char ch = model.currentChar();
        if (Symbols.isInitialNameChar(ch)) {
            CharArray name = model.getName();
            validator.mentionedElementNames.add(name);
            ch = model.currentChar();
            if (ch == '?' || ch == '*' || ch == '+') {
                model.nextChar();
                return new Automaton(new Automaton(name), ch);
            }
            return new Automaton(name);
        }
        if (ch == '(') {
            Automaton a;
            block9: {
                model.nextChar();
                char type = ' ';
                a = Automaton.build(validator, model);
                ch = model.currentChar();
                while (true) {
                    model.skipOptionalWhitespace();
                    ch = model.currentChar();
                    if (ch == ')') break block9;
                    if (ch != '|' && ch != ',') break;
                    if (type == ' ') {
                        type = ch;
                    } else if (type != ch) {
                        throw new ValidationException(validator, "A bracketed expression cannot contain commas(',') and strokes('|') simultaneously." + model);
                    }
                    model.nextChar();
                    a = new Automaton(a, Automaton.build(validator, model), ch);
                }
                throw new ValidationException(validator, "Comma(',') or stroke('|') or closing bracket(')') expected." + model);
            }
            model.confirm(")");
            ch = model.currentChar();
            if (ch == '?' || ch == '*' || ch == '+') {
                model.nextChar();
                return new Automaton(a, ch);
            }
            return a;
        }
        if (model.finished()) {
            throw new ValidationException(validator, "Unexpected end of model." + model);
        }
        throw new ValidationException(validator, "Name or opening bracket('(') expected." + model);
    }

    static HashSet getNamedChildren(State x) {
        if (x == null) {
            return new HashSet();
        }
        if (x.name != null) {
            HashSet<State> r = new HashSet<State>();
            r.add(x);
            return r;
        }
        HashSet r = new HashSet();
        r.addAll(Automaton.getNamedChildren(x.next1));
        r.addAll(Automaton.getNamedChildren(x.next2));
        return r;
    }
}

