/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class NamespaceHandlerEx
implements INamespaceHandler {
    protected XMLParser parent = null;
    public static final CharArray defaultPrefixName = new CharArray("<<<>>>").setStatic();
    protected CharArray defaultPrefixMapping = CharArray.EMPTY;
    protected Stack defaultUri = null;
    protected int level = 0;
    protected Hashtable hashNS = null;
    protected Vector<List<CharArray>> nsLevels = null;
    private boolean hashNSDirty = true;
    protected ArrayList<String[]> endedPrefMappings = new ArrayList();
    private Stack stIsMappedRes = null;
    private final ArrayList<CharArray> EMPTY_LIST = new ArrayList();

    public NamespaceHandlerEx(XMLParser parent) {
        this.defaultUri = new Stack();
        this.hashNS = new Hashtable();
        this.nsLevels = new Vector();
        defaultPrefixName.bufferHash();
        this.reuse(parent);
    }

    public boolean isPrefMappingChangedAndClear() {
        boolean dirty = this.hashNSDirty;
        this.hashNSDirty = false;
        return dirty;
    }

    @Override
    public INamespaceHandler reuse(XMLParser parent) {
        this.parent = parent;
        this.level = 0;
        this.nsLevels.clear();
        this.defaultUri.clear();
        this.hashNS.clear();
        this.hashNSDirty = true;
        this.addNamespace(XMLParser.crXML, XMLParser.caXMLNamespace);
        this.addNamespace(XMLParser.caXMLNS, XMLParser.crXMLNSNamespace);
        this.addNamespace(defaultPrefixName, CharArray.EMPTY);
        ArrayList<CharArray> prefixes = new ArrayList<CharArray>();
        prefixes.add(XMLParser.crXML);
        prefixes.add(XMLParser.caXMLNS);
        prefixes.add(defaultPrefixName);
        this.nsLevels.add(this.level, prefixes);
        this.defaultPrefixMapping = CharArray.EMPTY;
        this.levelUp();
        return this;
    }

    @Override
    public void print() {
    }

    @Override
    public void addDefault(CharArray uri) {
        this.add(defaultPrefixName, uri.copy());
    }

    @Override
    public CharArray getDefault() {
        return this.get(defaultPrefixName);
    }

    @Override
    public CharArray get(CharArray prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultPrefixMapping;
        }
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            return (CharArray)stackURIs.peek();
        }
        return CharArray.EMPTY;
    }

    @Override
    public CharArray getAttr(CharArray prefix) {
        CharArray result = CharArray.EMPTY;
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            result = (CharArray)stackURIs.peek();
        }
        return result;
    }

    @Override
    public CharArray isMapped(CharArray prefix) throws Exception {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultPrefixMapping;
        }
        try {
            return (CharArray)((Stack)this.hashNS.get(prefix)).peek();
        }
        catch (Exception exception) {
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
    }

    @Override
    public CharArray isMappedAttr(CharArray prefix) throws Exception {
        if (prefix != null && prefix.length() > 0) {
            this.stIsMappedRes = (Stack)this.hashNS.get(prefix);
            if (this.stIsMappedRes != null) {
                return (CharArray)this.stIsMappedRes.peek();
            }
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
        return CharArray.EMPTY;
    }

    @Override
    public void add(CharArray prefix, CharArray uri) {
        if (!prefix.getStatic()) {
            prefix = prefix.copy();
        }
        if (!uri.getStatic()) {
            uri = uri.copy();
        }
        this.addNamespace(prefix, uri);
        if (this.nsLevels.size() > this.level) {
            List<CharArray> prefixes = this.nsLevels.get(this.level);
            if (prefixes != null) {
                prefixes.add(prefix);
            } else {
                prefixes = new ArrayList<CharArray>();
                prefixes.add(prefix);
                this.nsLevels.set(this.level, prefixes);
            }
        } else {
            ArrayList<CharArray> prefixes = new ArrayList<CharArray>();
            prefixes.add(prefix);
            this.nsLevels.setSize(this.level + 1);
            this.nsLevels.set(this.level, prefixes);
        }
    }

    @Override
    public void levelUp() {
        ++this.level;
        this.endedPrefMappings.clear();
    }

    @Override
    public void levelDown() throws Exception {
        --this.level;
        this.endedPrefMappings.clear();
        if (this.nsLevels.size() > this.level) {
            ArrayList prefixes = (ArrayList)this.nsLevels.get(this.level);
            if (prefixes != null) {
                for (CharArray prefix : prefixes) {
                    CharArray ns = this.removeLast(prefix);
                    this.endedPrefMappings.add(new String[]{prefix.getString(), ns.getString()});
                }
                prefixes = null;
            }
            this.nsLevels.remove(this.level);
        }
    }

    @Override
    public void findNamespaceNodes(Element el, NamespaceManager nsmanager) {
        NamedNodeMap nm = el.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr attr = (Attr)nm.item(i);
            String prefix = attr.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                this.add(new CharArray(attr.getLocalName()), new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            } else if (prefix.length() == 0 && attr.getLocalName().equals("xmlns")) {
                this.addDefault(new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            }
            ++i;
        }
    }

    @Override
    public Hashtable getNamespaceMappings() {
        Hashtable<CharArray, String> mappings = new Hashtable<CharArray, String>();
        Enumeration enum1 = this.hashNS.keys();
        while (enum1.hasMoreElements()) {
            Stack uri;
            Object prefix = enum1.nextElement();
            if (prefix == XMLParser.crXML || prefix == XMLParser.caXMLNS || (uri = (Stack)this.hashNS.get(prefix)) == null || uri.isEmpty()) continue;
            mappings.put(prefix.equals(defaultPrefixName) ? CharArray.EMPTY : prefix, ((CharArray)uri.peek()).getString());
        }
        return mappings;
    }

    protected void addNamespace(CharArray prefix, CharArray uri) {
        Stack<CharArray> stackURIs = (Stack<CharArray>)this.hashNS.get(prefix);
        if (stackURIs != null) {
            stackURIs.push(uri);
            if (prefix == defaultPrefixName) {
                this.defaultPrefixMapping = uri;
            }
        } else {
            stackURIs = new Stack<CharArray>();
            stackURIs.push(uri);
            this.hashNS.put(prefix, stackURIs);
        }
        this.hashNSDirty = true;
    }

    protected CharArray removeLast(CharArray prefix) {
        CharArray result = null;
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            result = (CharArray)stackURIs.pop();
            if (prefix == defaultPrefixName) {
                this.defaultPrefixMapping = (CharArray)stackURIs.peek();
            }
            if (stackURIs.empty()) {
                this.hashNS.remove(prefix);
                stackURIs = null;
            }
            this.hashNSDirty = true;
        }
        return result;
    }

    protected void removePrefix(CharArray prefix) {
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public List<CharArray> getPrefixesOnLastStartElement() {
        if (this.level > this.nsLevels.size()) {
            return this.EMPTY_LIST;
        }
        return this.nsLevels.get(this.level - 1);
    }

    public List<String[]> getEndedPrefixMappings() {
        return this.endedPrefMappings;
    }
}

