/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.ParserEOFException;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.IXMLStream;
import com.sap.engine.lib.xml.parser.helpers.UTF8Encoding;
import com.sap.engine.lib.xml.parser.readers.EncodedDataReader;
import com.sap.engine.lib.xml.util.CharArrayInputStream;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import com.sap.engine.lib.xsl.xpath.IntVector;
import com.sap.engine.lib.xsl.xslt.pool.ObjectPool;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import org.xml.sax.InputSource;

public final class AdvancedXMLStreamReader
implements IXMLStream {
    private Vector sourceStack = new Vector();
    private int sourcePtr = -1;
    private int _pk_b;
    private boolean sourceChanged = false;
    private ObjectPool encodedDataReaderPool = new ObjectPool(EncodedDataReader.class, 15, 10);
    private int _cs_ptr = -20;
    private EncodedDataReader _cs_src = null;
    public XMLParser xmlParser = null;
    private int currentSID = 0;
    private IntVector finishedSid = new IntVector();
    private boolean insertSpaces = false;
    private boolean insertTrailingSpace = false;
    private boolean insertLeadingSpace = false;
    private boolean utf16beDetected = false;
    private int lowSurrogate = -1;
    private Random rand = new Random();

    public AdvancedXMLStreamReader(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    public AdvancedXMLStreamReader reuse(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
        this.sourceStack.clear();
        this.sourcePtr = -1;
        this.sourceChanged = false;
        this._cs_ptr = -20;
        this._cs_src = null;
        this.currentSID = 0;
        this.finishedSid.clear();
        this.insertSpaces = false;
        this.insertTrailingSpace = false;
        this.insertLeadingSpace = false;
        this.encodedDataReaderPool.releaseAllObjects();
        return this;
    }

    private EncodedDataReader getCurrentSource() {
        if (this.sourcePtr == this._cs_ptr) {
            return this._cs_src;
        }
        this._cs_src = (EncodedDataReader)this.sourceStack.get(this.sourcePtr);
        this._cs_ptr = this.sourcePtr;
        return this._cs_src;
    }

    @Override
    public boolean getLiteral() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLiteral();
    }

    @Override
    public void setLiteral(boolean value) {
        (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).setLiteral(true);
    }

    @Override
    public int getRow() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getRow();
    }

    @Override
    public int getCol() {
        return (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getCol();
    }

    @Override
    public char getLastChar() {
        return (char)this._pk_b;
    }

    @Override
    public void setLastChar(int value) {
        this._pk_b = value;
    }

    public int loadLastChar() throws Exception {
        return this.read();
    }

    private void reset(char[] oldChars, int length) {
        (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).reset(oldChars, length);
    }

    @Override
    public char read() throws Exception {
        if (this.lowSurrogate != -1) {
            char c = (char)this.lowSurrogate;
            this.lowSurrogate = -1;
            return c;
        }
        do {
            if (this.sourceChanged) {
                this.sourceChanged = false;
                this._pk_b = (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLastChar();
                continue;
            }
            this._pk_b = (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).read();
        } while (this.sourceChanged);
        if (this._pk_b >= 65536 && this._pk_b <= 0x10FFFF) {
            this.lowSurrogate = (this._pk_b - 65536) % 1024 + 56320;
            this._pk_b = (char)((this._pk_b - 65536) / 1024 + 55296);
        }
        return (char)this._pk_b;
    }

    @Override
    public boolean scanByte(char b) throws Exception {
        if (this.getLastChar() == b) {
            this.loadLastChar();
            return true;
        }
        return false;
    }

    @Override
    public boolean scanChars(char[] b) throws Exception {
        int l = b.length;
        int i = 0;
        while (i < l) {
            if (b[i] != (char)this._pk_b) {
                return false;
            }
            this.read();
            ++i;
        }
        return true;
    }

    @Override
    public boolean scanString(String b) throws Exception {
        int l = b.length();
        int i = 0;
        while (i < l) {
            if (b.charAt(i) != this._pk_b) {
                return false;
            }
            this.read();
            ++i;
        }
        return true;
    }

    private void addSource(EncodedDataReader src) throws ParserException {
        int i = 1;
        while (i < this.sourceStack.size()) {
            if (((EncodedDataReader)this.sourceStack.get(i)).getID().equals(src.getID())) {
                throw new ParserException("XMLError: You cannot read the same entity 2 times (recursion!!!)", this.getID(), this.getRow(), this.getCol());
            }
            ++i;
        }
        if (this.sourcePtr > -1) {
            this.getCurrentSource().setLastChar(this.getLastChar());
            src.setLiteral((this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getLiteral());
        }
        src.setSID(this.currentSID++);
        this.sourceStack.add(src);
        ++this.sourcePtr;
    }

    public void addInputFromFile(CharArray fname, CharArray id) throws FileNotFoundException, Exception {
        InputStream in = null;
        try {
            URL url = new URL(fname.toString());
            in = url.openStream();
        }
        catch (Exception exception) {
            in = new FileInputStream(fname.toString());
        }
        this.addInputFromInputStream(in, id);
    }

    @Override
    public void addInputFromCharArray(CharArray src, CharArray id) throws Exception {
        CharArrayInputStream cain = new CharArrayInputStream(src);
        this.addInputFromInputStream(cain, id);
    }

    @Override
    public void addInputSource(InputSource src) throws Exception {
        String systemId = src.getSystemId();
        if (systemId == null) {
            systemId = Integer.toString(this.rand.nextInt());
        }
        this.addInputSource(src, new CharArray(systemId));
    }

    @Override
    public void addInputSource(InputSource src, CharArray id) throws Exception {
        if (src.getCharacterStream() != null) {
            this.addInputFromReader(src.getCharacterStream(), id);
        } else if (src.getByteStream() != null) {
            this.addInputFromInputStream(src.getByteStream(), id);
        } else if (src.getSystemId() != null) {
            this.addInputFromFile(new CharArray(src.getSystemId()), id);
        }
    }

    @Override
    public void addInputFromInputStream(InputStream is, CharArray id) throws Exception {
        this.addSource(((EncodedDataReader)this.encodedDataReaderPool.getObject()).reuse(this, is, id));
        this.setReadRaw(true);
        this.read();
        int bom = this.checkBOM();
        switch (bom) {
            case 0: 
            case 1: 
            case 3: {
                this.setEncoding(UTF8Encoding.NAME);
                break;
            }
            case 2: 
            case 4: {
                this.setEncoding(EncodingHandler.utf_16);
                break;
            }
            case 7: 
            case 8: {
                this.utf16beDetected = true;
                this.setEncoding(EncodingHandler.utf_16be);
                break;
            }
            case 6: {
                this.setEncoding(EncodingHandler.CP1047);
                break;
            }
            default: {
                throw new ParserException("Unknown Byte-Order-Mark. XML MUST begin either with WhiteSpace or with '<?xml', and not: '" + this.getLastChar() + this.read() + this.read() + "'", this.getID(), 1, 1);
            }
        }
        this.setReadRaw(false);
        if (bom != 0) {
            this.read();
        }
    }

    @Override
    public void addInputFromEntity(Entity ent) throws Exception {
        if (ent.isInternal()) {
            this.addInputFromCharArray(ent.getValue(), ent.getName());
        } else if (this.xmlParser != null) {
            if (!this.xmlParser.getExternalGeneralEntities()) {
                this.xmlParser.docHandler.onCustomEvent(1003, ent.getName());
            } else {
                InputSource isource = null;
                if (this.xmlParser.getEntityResolver() != null) {
                    URL url = this.xmlParser.urlLoader.loadAndPush(ent.getSys().toString());
                    isource = this.xmlParser.getEntityResolver().resolveEntity(ent.getPub().toString(), ent.getSys().toString());
                    if (isource == null) {
                        InputStream urlStream = null;
                        try {
                            urlStream = url.openStream();
                        }
                        catch (IOException ioe) {
                            String systemId = url.toString();
                            if (systemId.startsWith("http://localhost/")) {
                                String resourceName;
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                urlStream = loader.getResourceAsStream(resourceName = systemId.substring(17));
                                if (urlStream == null) {
                                    throw new IOException("Failed to load resource from the context classloader of the current thread! Loading from classloader was caused by: " + ioe.toString());
                                }
                            }
                            throw ioe;
                        }
                        isource = new InputSource(urlStream);
                        isource.setSystemId(url.toString());
                    }
                } else {
                    this.xmlParser.urlLoader.loadAndPush(ent.getSys().toString());
                    isource = this.xmlParser.urlLoader.resolveEntity(ent.getPub().toString(), ent.getSys().toString());
                }
                this.addInputSource(isource, ent.getSys());
            }
        } else {
            this.addInputFromFile(ent.getSys(), ent.getName());
        }
        this.getCurrentSource().setName(ent.getName());
    }

    @Override
    public void addInputFromReader(Reader reader, CharArray id) throws Exception {
        this.addInputFromInputStream(new ReaderInputStream(reader), id);
    }

    public void onEncodedDataReaderEOF() throws Exception {
        EncodedDataReader finishingEncodedDataReader;
        EncodedDataReader encodedDataReader = finishingEncodedDataReader = this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource();
        if (this.xmlParser != null) {
            this.xmlParser.onEncodedDataReaderEOF(finishingEncodedDataReader);
        }
        this.finishedSid.add(finishingEncodedDataReader.getSID());
        if (this.sourcePtr == 0) {
            this.encodedDataReaderPool.releaseObject(finishingEncodedDataReader);
            if (this.xmlParser != null) {
                this.xmlParser.onDocumentEOF();
            }
        } else {
            do {
                InputStream streamToClose;
                if ((streamToClose = finishingEncodedDataReader.getInputStream()) != null && this.xmlParser != null && this.xmlParser.getCloseStreams()) {
                    streamToClose.close();
                }
                this.encodedDataReaderPool.releaseObject(this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource());
                this.sourceStack.removeElementAt(this.sourcePtr);
                --this.sourcePtr;
                this.sourceChanged = true;
            } while (this.sourcePtr >= 0 && (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).isFinished());
            if (this.sourcePtr < 0) {
                throw new ParserEOFException("End of EncodedDataReader: " + (this.sourcePtr == this._cs_ptr ? this._cs_src : this.getCurrentSource()).getID() + " reached.");
            }
        }
    }

    public int getPtr() {
        return this.sourcePtr;
    }

    @Override
    public boolean isFinished(int sid) {
        return this.finishedSid.contains(sid);
    }

    @Override
    public void clearFinished(int sid) {
        this.finishedSid.removeElement(sid);
    }

    @Override
    public int getSourceID() {
        return this.getCurrentSource().getSID();
    }

    public void insertSpaces() {
        this.insertLeadingSpace = true;
        this.insertTrailingSpace = false;
        this.insertSpaces = true;
    }

    @Override
    public void setEncoding(CharArray enc) throws ParserException {
        if (this.utf16beDetected && (enc.toLowerCase().equals("utf-16") || enc.toLowerCase().equals("utf16"))) {
            this.getCurrentSource().setEncoding(new CharArray("utf-16be"));
        } else if (enc.toLowerCase().equals("iso-10646-ucs-2")) {
            if (this.utf16beDetected) {
                this.getCurrentSource().setEncoding(EncodingHandler.ISO_10646_UCS_2_BE);
            } else {
                this.getCurrentSource().setEncoding(EncodingHandler.ISO_10646_UCS_2_LE);
            }
        } else {
            this.getCurrentSource().setEncoding(enc);
        }
    }

    @Override
    public void setReadRaw(boolean value) {
        this.getCurrentSource().setReadRaw(value);
    }

    protected int checkBOM() throws Exception {
        char b = this.getLastChar();
        if (b == '<') {
            char[] oldChars = new char[4];
            int length = 0;
            oldChars[length++] = b;
            b = this.read();
            oldChars[length++] = b;
            if (b == '\u0000') {
                b = this.read();
                oldChars[length++] = b;
                if (b == '?') {
                    b = this.read();
                    oldChars[length++] = b;
                    if (b == '\u0000') {
                        this.reset(oldChars, length);
                        return 2;
                    }
                }
            }
            this.reset(oldChars, length);
            this.read();
            return 0;
        }
        if (b == '\u00ef') {
            b = this.read();
            if (b == '\u00bb' && (b = this.read()) == '\u00bf') {
                return 3;
            }
        } else if (b == '\u00ff') {
            b = this.read();
            if (b == '\u00fe') {
                return 4;
            }
        } else if (b == '\u00fe') {
            b = this.read();
            if (b == '\u00ff') {
                return 7;
            }
        } else {
            if (b == '\u0000') {
                char[] oldChars = new char[4];
                int length = 0;
                oldChars[length++] = b;
                b = this.read();
                oldChars[length++] = b;
                if (b == '<') {
                    b = this.read();
                    oldChars[length++] = b;
                    if (b == '\u0000') {
                        b = this.read();
                        oldChars[length++] = b;
                        if (b == '?') {
                            this.reset(oldChars, length);
                            return 8;
                        }
                    }
                }
                this.reset(oldChars, length);
                this.read();
                return 0;
            }
            if (b == 'L') {
                char[] oldChars = new char[4];
                int length = 0;
                oldChars[length++] = b;
                b = this.read();
                oldChars[length++] = b;
                b = this.read();
                oldChars[length++] = b;
                b = this.read();
                oldChars[length++] = b;
                if (oldChars[0] == 'L' && oldChars[1] == 'o' && oldChars[2] == '\u00a7' && oldChars[3] == '\u0094') {
                    this.reset(oldChars, length);
                    return 6;
                }
                this.reset(oldChars, length - 1);
                this.read();
                return 0;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public CharArray getID() {
        return this.getCurrentSource().getID();
    }

    @Override
    public boolean scanS() throws Exception {
        char ch_scans;
        if (!Symbols.isWhitespace((char)this._pk_b)) {
            return false;
        }
        while ((ch_scans = this.read()) == ' ' || ch_scans == '\r' || ch_scans == '\n' || ch_scans == '\t') {
        }
        return true;
    }

    @Override
    public CharArray getEncoding() {
        return this.getCurrentSource().encoding.getName();
    }

    @Override
    public void close() throws IOException {
        EncodedDataReader currentDataReader = this.getCurrentSource();
        if (currentDataReader != null) {
            currentDataReader.closeInputStream();
        }
    }
}

