/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;

public class UTF16Encoding
extends Encoding {
    private byte[] utf16buf = new byte[2];
    public boolean hasbyte = false;
    private CharArray name;
    private boolean bigEndian;

    public UTF16Encoding(boolean bigEndian) {
        this.bigEndian = bigEndian;
        this.name = bigEndian ? EncodingHandler.utf_16be : EncodingHandler.utf_16;
    }

    @Override
    public int process(byte ch) {
        int b2;
        int b1;
        if (!this.hasbyte) {
            this.utf16buf[0] = ch;
            this.hasbyte = true;
            return -2;
        }
        this.hasbyte = false;
        if (this.bigEndian) {
            b1 = this.utf16buf[0] << 8 & 0xFF00;
            b2 = ch & 0xFF;
        } else {
            b1 = ch << 8 & 0xFF00;
            b2 = this.utf16buf[0] & 0xFF;
        }
        return b1 | b2;
    }

    @Override
    public int reverseEncode(byte[] converted, int ch) {
        if (!this.bigEndian) {
            converted[0] = (byte)(ch & 0xFF);
            converted[1] = (byte)((ch & 0xFF00) >> 8);
        } else {
            converted[0] = (byte)((ch & 0xFF00) >> 8);
            converted[1] = (byte)(ch & 0xFF);
        }
        return 2;
    }

    @Override
    public CharArray getName() {
        return this.name;
    }

    @Override
    public void reset() {
        this.hasbyte = false;
    }
}

