/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLComparator {
    private static Vector getVectForAttribs(NamedNodeMap attribs) {
        Vector<String> vect = new Vector<String>();
        if (attribs != null) {
            int len = attribs.getLength();
            int i = 0;
            while (i < len) {
                Attr attr = (Attr)attribs.item(i);
                String name = attr.getName();
                String prefix = attr.getPrefix();
                if (!"xmlns".equals(prefix) && !"xmlns".equals(name)) {
                    vect.addElement(name);
                }
                ++i;
            }
        }
        return vect;
    }

    protected static boolean compareAttributes(NamedNodeMap newAttribs, NamedNodeMap oldAttribs) {
        int oldLen;
        Vector newAttribsVect = XMLComparator.getVectForAttribs(newAttribs);
        Vector oldAttribsVect = XMLComparator.getVectForAttribs(oldAttribs);
        int newLen = newAttribsVect.size();
        if (newLen != (oldLen = oldAttribsVect.size())) {
            return false;
        }
        int i = 0;
        while (i < newLen) {
            String name = newAttribsVect.elementAt(i).toString();
            Attr newAttr = (Attr)newAttribs.getNamedItem(name);
            String newValue = newAttr.getValue();
            Attr oldAttr = (Attr)oldAttribs.getNamedItem(name);
            if (oldAttr == null) {
                return false;
            }
            String oldValue = oldAttr.getValue();
            if (!newValue.equals(oldValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean compareNodeLists(NodeList newList, NodeList oldList) {
        int oldLen;
        if (newList == null || oldList == null) {
            return newList == null && oldList == null;
        }
        int newLen = newList.getLength();
        if (newLen != (oldLen = oldList.getLength())) {
            return false;
        }
        int i = 0;
        while (i < newLen) {
            if (!XMLComparator.compareNodes(newList.item(i), oldList.item(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean compareNodes(Node newNode, Node oldNode) {
        NodeList oldList;
        NodeList newList;
        NamedNodeMap oldAttribs;
        if (newNode == null || oldNode == null) {
            return newNode == null && oldNode == null;
        }
        newNode.normalize();
        oldNode.normalize();
        short newType = newNode.getNodeType();
        short oldType = oldNode.getNodeType();
        if (newType != oldType) {
            return false;
        }
        String newLocalName = newNode.getLocalName();
        String oldLocalName = oldNode.getLocalName();
        if (newLocalName == null ? oldLocalName != null : !newLocalName.equals(oldLocalName)) {
            return false;
        }
        String newNamespace = newNode.getNamespaceURI();
        String oldNamespace = oldNode.getNamespaceURI();
        if (newNamespace == null ? oldNamespace != null : !newNamespace.equals(oldNamespace)) {
            return false;
        }
        NamedNodeMap newAttribs = newNode.getAttributes();
        if (!XMLComparator.compareAttributes(newAttribs, oldAttribs = oldNode.getAttributes())) {
            return false;
        }
        String newValue = newNode.getNodeValue();
        String oldValue = oldNode.getNodeValue();
        if (newValue == null) {
            if (oldValue != null) {
                return false;
            }
        } else {
            if (oldValue == null) {
                return false;
            }
            if (!newValue.trim().equals(oldValue.trim())) {
                return false;
            }
        }
        return XMLComparator.compareNodeLists(newList = newNode.getChildNodes(), oldList = oldNode.getChildNodes());
    }

    private static boolean domCompare(File newXML, File oldXML) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document newDoc = builder.parse(newXML);
        Document oldDoc = builder.parse(oldXML);
        return XMLComparator.compareNodes(newDoc.getDocumentElement(), oldDoc.getDocumentElement());
    }

    private static boolean domCompare(InputStream newXML, InputStream oldXML) throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document newDoc = builder.parse(newXML, "nexXML");
        Document oldDoc = builder.parse(oldXML, "oldXML");
        return XMLComparator.compareNodes(newDoc.getDocumentElement(), oldDoc.getDocumentElement());
    }

    protected static String getStringForXML(File xml) throws Exception {
        try (FileInputStream in = new FileInputStream(xml);){
            String string = XMLComparator.getStringForXML(in);
            return string;
        }
    }

    protected static String getStringForXML(InputStream xml) throws Exception {
        String line;
        StringBuffer buf = new StringBuffer();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(xml));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            buf.append(String.valueOf(line) + (line.endsWith(">") ? "" : " "));
        }
        String str = buf.toString();
        int index = str.indexOf("<?xml");
        if (index == 0) {
            int index2 = str.indexOf("?>");
            String xmlDecl = str.substring(0, index2 + 2);
            str = String.valueOf(xmlDecl.toLowerCase(Locale.ENGLISH)) + str.substring(index2 + 2);
        }
        return str;
    }

    public static boolean compareXMLs(File newXML, File oldXML) throws Throwable {
        String oldStr;
        String newStr = XMLComparator.getStringForXML(newXML);
        if (newStr.equals(oldStr = XMLComparator.getStringForXML(oldXML))) {
            return true;
        }
        return XMLComparator.domCompare(newXML, oldXML);
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = in.read(b, 0, 1024)) != -1) {
            out.write(b, 0, len);
        }
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    public static boolean compareXMLs(InputStream newXML, InputStream oldXML) throws Throwable {
        byte[] oldBytes;
        byte[] newBytes = XMLComparator.getBytes(newXML);
        if (newBytes.length == (oldBytes = XMLComparator.getBytes(oldXML)).length) {
            boolean theSame = true;
            int i = 0;
            while (i < newBytes.length) {
                if (newBytes[i] != oldBytes[i]) {
                    theSame = false;
                    break;
                }
                ++i;
            }
            if (theSame) {
                return true;
            }
        }
        ByteArrayInputStream newIn = new ByteArrayInputStream(newBytes);
        ByteArrayInputStream oldIn = new ByteArrayInputStream(oldBytes);
        try {
            boolean bl = XMLComparator.domCompare(newIn, oldIn);
            return bl;
        }
        finally {
            newIn.close();
            oldIn.close();
        }
    }

    public static boolean compareXMLs(String newXMLStr, InputStream oldXMLStr) throws Exception {
        Document newDoc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (ByteArrayInputStream newXMLStream = new ByteArrayInputStream(newXMLStr.getBytes());){
            newDoc = builder.parse(newXMLStream, newXMLStr);
        }
        Document oldDoc = builder.parse(oldXMLStr, "oldXML");
        return XMLComparator.compareNodes(newDoc.getDocumentElement(), oldDoc.getDocumentElement());
    }
}

