/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.readers;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.AdvancedXMLStreamReader;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xml.parser.helpers.UTF16Encoding;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLEncoder;

public class EncodedDataReader {
    protected AdvancedXMLStreamReader parent = null;
    protected int pos = 0;
    protected int ext = 0;
    public boolean eos = false;
    protected int a1;
    protected int a2;
    protected int restBytes = 0;
    protected int totalRead = 0;
    protected CharArray id = null;
    protected CharArray name = null;
    protected int iLevel = 0;
    protected int iRow = 1;
    protected int iCol = 1;
    protected int iMarkRow = 0;
    protected int iMarkCol = 0;
    protected boolean bLiteral = false;
    protected int lastchar;
    private int sid = -1;
    protected boolean bReadRaw = false;
    protected InputStream in = null;
    protected char[] buf = null;
    private char[] bufToRead;
    protected byte[] bytebuf = null;
    protected char[] mapping = null;
    protected boolean isUTF8 = true;
    protected int idx = 0;
    protected int DEFAULT_EXT = 10000;
    int x1;
    byte[] utf8buf = new byte[10];
    byte utf8buflen = 0;
    int utf8left = 0;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private static final CharArray crUTF8 = new CharArray("utf-8").setStatic();
    public Encoding encoding = this.encodingHandler.getEncoding(crUTF8);
    private OutputStream debugOutputStream;
    public int[] res = new int[2];

    public EncodedDataReader() {
        this.reuse();
    }

    public EncodedDataReader(AdvancedXMLStreamReader parent, InputStream in, CharArray id) {
        this.reuse(parent, in, id);
    }

    public EncodedDataReader(AdvancedXMLStreamReader parent, Reader rd, CharArray id) {
        this.reuse(parent, new ReaderInputStream(rd), id);
    }

    public EncodedDataReader reuse(AdvancedXMLStreamReader parent, InputStream in, CharArray id) {
        this.reuse();
        this.in = in;
        this.parent = parent;
        if (this.buf == null) {
            this.buf = new char[this.DEFAULT_EXT];
        }
        if (this.bytebuf == null) {
            this.bytebuf = new byte[this.DEFAULT_EXT];
        }
        this.ext = this.DEFAULT_EXT;
        this.id = id;
        this.eos = false;
        if (in instanceof ReaderInputStream) {
            this.setReadRaw(true);
        }
        this.initDebug();
        return this;
    }

    public EncodedDataReader reuse(AdvancedXMLStreamReader parent, Reader rd, CharArray id) {
        return this.reuse(parent, new ReaderInputStream(rd), id);
    }

    protected void reuse() {
        this.pos = 0;
        this.ext = this.DEFAULT_EXT;
        this.eos = false;
        this.restBytes = 0;
        this.totalRead = 0;
        this.iLevel = 0;
        this.iRow = 1;
        this.iCol = 1;
        this.iMarkRow = 0;
        this.iMarkCol = 0;
        this.bLiteral = false;
        this.bReadRaw = false;
        this.encoding = this.encodingHandler.getEncoding(crUTF8);
        this.encoding.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebug() {
        String fileName;
        String debugDir = SystemProperties.getProperty("sapxmltoolkit.debug.dir");
        if (debugDir == null) {
            this.debugOutputStream = null;
            return;
        }
        File dir = new File(debugDir);
        dir.mkdirs();
        String systemID = String.valueOf(this.id);
        String threadName = Thread.currentThread().getName();
        String newFileName = fileName = URLEncoder.encode("_" + threadName + '_' + systemID);
        Class<EncodedDataReader> clazz = EncodedDataReader.class;
        synchronized (EncodedDataReader.class) {
            File f;
            do {
                f = new File(dir, newFileName);
                newFileName = String.valueOf(fileName) + '_' + System.currentTimeMillis();
            } while (f.exists());
            try {
                this.debugOutputStream = new FileOutputStream(f);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return;
        }
    }

    public int read() throws Exception {
        if (this.restBytes == 0) {
            this.fetchData();
        }
        if (this.eos) {
            this.parent.onEncodedDataReaderEOF();
            if (this.parent.xmlParser != null && this.parent.xmlParser.getCloseStreams()) {
                this.in.close();
            }
            this.in = null;
            return 0;
        }
        --this.restBytes;
        if (this.buf[this.pos] == '\n') {
            ++this.iRow;
            this.iCol = 1;
        } else if (this.buf[this.pos] != '\r') {
            ++this.iCol;
        }
        if (this.bReadRaw) {
            this.x1 = this.buf[this.pos];
        } else {
            this.x1 = this.encoding.process((byte)this.buf[this.pos]);
            if (this.x1 == -2) {
                ++this.pos;
                return this.read();
            }
            if (this.x1 == -1) {
                throw new ParserException("Incorrect encoded sequence detected at character (hex) 0x" + Integer.toHexString(this.buf[this.pos]) + ", (bin) " + Integer.toBinaryString(this.buf[this.pos]) + ". Check whether the input parsed contains correctly encoded characters. Encoding used is: '" + this.encoding.getName() + "'", this.parent.getID(), this.iRow, this.iCol);
            }
        }
        ++this.pos;
        return this.x1;
    }

    protected int readData(int off, int len) throws IOException {
        try {
            if (this.bufToRead != null) {
                int l = this.bufToRead.length;
                System.arraycopy(this.bufToRead, 0, this.buf, off, l);
                this.bufToRead = null;
                return l;
            }
            if (this.in instanceof ReaderInputStream) {
                return ((ReaderInputStream)this.in).read(this.buf, off, len);
            }
            int bb = this.in.read(this.bytebuf, off, len);
            if (this.debugOutputStream != null) {
                if (bb == -1) {
                    this.debugOutputStream.close();
                } else if (bb > 0) {
                    this.debugOutputStream.write(this.bytebuf, 0, bb);
                    this.debugOutputStream.flush();
                }
            }
            int bb2 = bb;
            while (bb2-- > 0) {
                this.buf[bb2] = (char)(this.bytebuf[bb2] & 0xFF);
            }
            return bb;
        }
        catch (EOFException eOFException) {
            if (this.debugOutputStream != null) {
                this.debugOutputStream.close();
            }
            return -1;
        }
    }

    protected void moveData(int offsetStart, int offsetEnd, int size) throws Exception {
        if (offsetStart > offsetEnd || offsetStart + size <= offsetEnd) {
            System.arraycopy(this.buf, offsetStart, this.buf, offsetEnd, size);
        } else if (offsetStart + size > offsetEnd) {
            byte[] bbb = new byte[size];
            System.arraycopy(this.buf, offsetStart, bbb, 0, size);
            System.arraycopy(bbb, 0, this.buf, offsetEnd, size);
        }
    }

    protected int getBufLen() {
        return this.buf.length;
    }

    public void setLastChar(int value) {
        this.lastchar = value;
    }

    public int getLastChar() {
        return this.lastchar;
    }

    protected void fetchData() throws Exception {
        this.pos = 0;
        this.a1 = this.getBufLen() - this.pos;
        this.a2 = this.readData(this.pos, this.a1);
        while (this.a2 == 0) {
            Thread.sleep(5L);
            this.a2 = this.readData(this.pos, this.a1);
        }
        if (this.a2 == -1) {
            this.eos = true;
            this.restBytes = 0;
        } else {
            this.restBytes = this.a2;
        }
    }

    public int getRow() {
        return this.iRow;
    }

    public int getCol() {
        return this.iCol;
    }

    public CharArray getID() {
        return this.id;
    }

    public int getRestBytes() {
        return this.restBytes;
    }

    public boolean getLiteral() {
        return this.bLiteral;
    }

    public void setLiteral(boolean value) {
        this.bLiteral = value;
    }

    public boolean isFinished() {
        return this.eos && this.restBytes <= 0;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getSID() {
        return this.sid;
    }

    public void setSID(int i) {
        this.sid = i;
    }

    public void setReadRaw(boolean b) {
        this.bReadRaw = b;
        if (this.in instanceof ReaderInputStream) {
            this.bReadRaw = true;
        } else if (this.encoding instanceof UTF16Encoding) {
            this.bReadRaw = false;
        }
    }

    public int[] parseUTF8toUCS4(byte[] data, int off, int len) {
        this.res[0] = len;
        if (len == 6) {
            this.res[1] = (data[off] & 1) << 30;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 24;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 4] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 5] & 0x3F;
        } else if (len == 5) {
            this.res[1] = (data[off] & 3) << 24;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 4] & 0x3F;
        } else if (len == 4) {
            this.res[1] = (data[off] & 7) << 18;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 3] & 0x3F;
        } else if (len == 3) {
            this.res[1] = (data[off] & 0xF) << 12;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 2] & 0x3F;
        } else if (len == 2) {
            this.res[1] = (data[off] & 0x1F) << 6;
            this.res[1] = this.res[1] | data[off + 1] & 0x3F;
        } else if (len == 1) {
            this.res[1] = data[off];
        }
        return this.res;
    }

    public int getUTF8CharCount(byte ch) {
        if ((ch & 0xFC) == 252) {
            return 6;
        }
        if ((ch & 0xF8) == 248) {
            return 5;
        }
        if ((ch & 0xF0) == 240) {
            return 4;
        }
        if ((ch & 0xE0) == 224) {
            return 3;
        }
        if ((ch & 0xC0) == 192) {
            return 2;
        }
        return 1;
    }

    public void setName(CharArray name) {
        this.name = name.copy();
    }

    public CharArray getName() {
        return this.name;
    }

    public void setEncoding(CharArray enc) throws ParserException {
        if (this.in instanceof ReaderInputStream) {
            this.setReadRaw(true);
        } else {
            if (enc == null) {
                throw new ParserException("Unrecognized encoding. The value is null.", this.iRow, this.iCol);
            }
            if (this.encodingHandler.getEncoding(enc) != null) {
                this.encoding = this.encodingHandler.getEncoding(enc);
            } else if (enc != null && enc.length() > 0) {
                throw new ParserException("Unrecognized encoding " + enc.toString(), this.iRow, this.iCol);
            }
        }
    }

    public void reset(char[] oldChars, int length) {
        if (this.restBytes + length <= this.buf.length) {
            System.arraycopy(this.buf, this.pos, this.buf, length, this.restBytes);
            System.arraycopy(oldChars, 0, this.buf, 0, length);
            this.restBytes += length;
        } else {
            this.bufToRead = new char[length - this.pos];
            int l = this.buf.length - length;
            System.arraycopy(this.buf, this.pos + l, this.bufToRead, 0, this.bufToRead.length);
            System.arraycopy(this.buf, this.pos, this.buf, length, l);
            System.arraycopy(oldChars, 0, this.buf, 0, length);
            this.restBytes = this.buf.length;
        }
        this.iCol = 1;
        this.iRow = 1;
        this.pos = 0;
    }

    public void closeInputStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("EncodedDataReader #" + this.hashCode() + " { \r\n");
        ret.append("  encoding=" + this.encoding + "\r\n");
        ret.append("} \r\n");
        return ret.toString();
    }
}

