/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.log.LogWriter;

class CharStacker {
    private int INITIAL_CHARSIZE = 2048;
    private int INITIAL_INDEXSIZE = 256;
    private char[] charbuffer = new char[this.INITIAL_CHARSIZE];
    private int[] intbuffer = new int[this.INITIAL_INDEXSIZE];
    private int charTop = 0;
    private int intTop = 0;

    private char[] resizeCharArray(char[] array, int newSize) {
        char[] result = new char[newSize];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private int[] resizeIntArray(int[] array, int newSize) {
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void pushChars(char[] chars) {
        int length = chars.length;
        if (this.intTop == this.intbuffer.length) {
            this.intbuffer = this.resizeIntArray(this.intbuffer, this.intbuffer.length * 2);
        }
        if (this.charTop + length > this.charbuffer.length) {
            this.charbuffer = this.resizeCharArray(this.charbuffer, this.charbuffer.length * 2 + length);
        }
        this.intbuffer[this.intTop] = this.charTop;
        ++this.intTop;
        System.arraycopy(chars, 0, this.charbuffer, this.charTop, length);
        this.charTop += length;
    }

    public char[] getChars() {
        return this.charbuffer;
    }

    public int getBegin() {
        return this.intbuffer[this.intTop - 1];
    }

    public int getSize() {
        return this.charTop - this.intbuffer[this.intTop - 1];
    }

    public void pop() {
        this.charTop -= this.charTop - this.intbuffer[this.intTop - 1];
        --this.intTop;
    }

    public void clear() {
        this.charTop = 0;
        this.intTop = 0;
    }

    public void writeStatistics() {
        LogWriter.getSystemLogWriter().println(" Charr buffer :" + this.charbuffer.length);
        LogWriter.getSystemLogWriter().println(" Int buffer :" + this.intbuffer.length);
        LogWriter.getSystemLogWriter().println(" Char top :" + this.charTop);
        LogWriter.getSystemLogWriter().println(" Int top :" + this.intTop);
    }
}

