/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ElementTokenWriter {
    private Hashtable prefixToNamespaceMapping;
    private Hashtable namespaceToPrefixMapping;
    private Document doc;
    private Element element;
    private ElementTokenWriter currentElementTokenWriter;
    private int enterCounter;
    static int a = 0;

    protected ElementTokenWriter(Document doc, Element element, Hashtable prefixToNamespaceMapping, Hashtable namespaceToPrefixMapping) {
        this.doc = doc;
        this.element = element;
        this.prefixToNamespaceMapping = prefixToNamespaceMapping == null ? new Hashtable() : (Hashtable)prefixToNamespaceMapping.clone();
        this.namespaceToPrefixMapping = namespaceToPrefixMapping == null ? new Hashtable() : (Hashtable)namespaceToPrefixMapping.clone();
        this.enterCounter = 0;
    }

    protected boolean isLeaved() {
        return this.element != null && this.enterCounter == 0;
    }

    protected void appendNamespaces(Hashtable prefixToNamespaceMapping) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.appendNamespaces(prefixToNamespaceMapping);
        } else {
            this.prefixToNamespaceMapping.putAll(prefixToNamespaceMapping);
            Enumeration prefixesEnum = prefixToNamespaceMapping.keys();
            while (prefixesEnum.hasMoreElements()) {
                Object prefix = prefixesEnum.nextElement();
                Object namespace = prefixToNamespaceMapping.get(prefix);
                this.namespaceToPrefixMapping.put(namespace, prefix);
            }
        }
    }

    private String determinePrefix(String namespace) {
        return (String)this.namespaceToPrefixMapping.get(namespace);
    }

    private String determineNamespace(String prefix) {
        return (String)this.prefixToNamespaceMapping.get(prefix);
    }

    private String createQName(String namespace, String localName) {
        String prefix = this.determinePrefix(namespace);
        if (prefix == null) {
            if (namespace.equals("")) {
                Object defaultNamespace = this.prefixToNamespaceMapping.get("");
                if (defaultNamespace == null) {
                    prefix = "";
                }
            } else {
                prefix = "ns" + a++;
                this.prefixToNamespaceMapping.put(prefix, namespace);
                this.namespaceToPrefixMapping.put(namespace, prefix);
            }
        }
        if (prefix == null) {
            throw new IllegalArgumentException("No prefix is mapped to the namespace '" + namespace + "'.");
        }
        return prefix.equals("") ? localName : String.valueOf(prefix) + ":" + localName;
    }

    protected void enter(String namespace, String localName) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.enter(namespace, localName);
        } else if (this.element == null) {
            String elementNamespace = this.processNamespace(namespace);
            this.element = this.doc.createElementNS(elementNamespace, this.createQName(elementNamespace, localName));
            ++this.enterCounter;
        } else {
            this.currentElementTokenWriter = new ElementTokenWriter(this.doc, null, this.prefixToNamespaceMapping, this.namespaceToPrefixMapping);
            this.currentElementTokenWriter.enter(namespace, localName);
            this.element.appendChild(this.currentElementTokenWriter.getElement());
            ++this.enterCounter;
        }
    }

    private String processNamespace(String namespace) {
        return namespace == null ? "" : namespace;
    }

    protected Element getElement() {
        return this.element;
    }

    protected void leave() {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.leave();
            if (this.currentElementTokenWriter.isLeaved()) {
                --this.enterCounter;
                this.currentElementTokenWriter = null;
            }
        } else {
            --this.enterCounter;
        }
    }

    protected String getPrefixForNamespace(String namespace) {
        if (this.currentElementTokenWriter != null) {
            return this.currentElementTokenWriter.getPrefixForNamespace(namespace);
        }
        return this.determinePrefix(namespace);
    }

    protected void setPrefixForNamespace(String prefix, String namespace) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.setPrefixForNamespace(prefix, namespace);
        } else {
            this.prefixToNamespaceMapping.put(prefix, namespace);
            this.namespaceToPrefixMapping.put(namespace, prefix);
        }
    }

    protected void writeAttribute(String namespace, String name, String value) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.writeAttribute(namespace, name, value);
        } else {
            if (this.element == null) {
                throw new IllegalStateException("Illegal state is detected for operation 'writeAttribute'. Parent element is not created. 'Enter' operation should be performed.");
            }
            String attribNamespace = this.processNamespace(namespace);
            Attr attrib = this.doc.createAttributeNS(attribNamespace, this.createQName(attribNamespace, name));
            attrib.setNodeValue(value);
            this.element.setAttributeNode(attrib);
        }
    }

    protected void writeContent(String content) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.writeContent(content);
        } else {
            if (this.element == null) {
                throw new IllegalStateException("Illegal state is detected for operation 'writeContent'. Parent element is not created. 'Enter' operation should be performed.");
            }
            Text textNode = this.doc.createTextNode(content);
            this.element.appendChild(textNode);
        }
    }

    protected void writeContentCData(char[] chars) {
        this.writeContentCData(chars, 0, chars.length);
    }

    protected void writeContentCData(char[] chars, int offset, int count) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.writeContentCData(chars, offset, count);
        } else {
            if (this.element == null) {
                throw new IllegalStateException("Illegal state is detected for operation 'writeContentCData'. Parent element is not created. 'Enter' operation should be performed.");
            }
            CDATASection cdataSection = this.doc.createCDATASection(new String(chars, offset, count));
            this.element.appendChild(cdataSection);
        }
    }

    protected void writeComment(String comment) {
        if (this.currentElementTokenWriter != null) {
            this.currentElementTokenWriter.writeComment(comment);
        } else {
            if (this.element == null) {
                throw new IllegalStateException("Illegal state is detected for operation 'writeComment'. Parent element is not created. 'Enter' operation should be performed.");
            }
            Comment commentNode = this.doc.createComment(comment);
            this.element.appendChild(commentNode);
        }
    }

    protected void writeXmlAttribute(String name, String value) {
        this.setPrefixForNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        this.writeAttribute("http://www.w3.org/2000/xmlns/", name, value);
    }
}

