/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

public final class PrefixHolder {
    public String namespace;
    private String[] contents;
    private int[] levels;
    private int top;
    private static final int INITIALSIZE = 32;

    public void init() {
        this.top = 0;
    }

    public PrefixHolder(String namespace) {
        this.namespace = namespace;
        this.contents = new String[32];
        this.levels = new int[32];
        this.top = 0;
    }

    public void enter(String s) {
        if (this.top != 0 && this.contents[this.top - 1].equals(s)) {
            int n = this.top - 1;
            this.levels[n] = this.levels[n] + 1;
            return;
        }
        if (this.top == this.contents.length) {
            String[] perm1 = new String[this.contents.length + 32];
            System.arraycopy(this.contents, 0, perm1, 0, this.contents.length);
            this.contents = perm1;
            int[] perm2 = new int[this.levels.length + 32];
            System.arraycopy(this.contents, 0, perm2, 0, this.contents.length);
            this.levels = perm2;
        }
        this.levels[this.top] = 1;
        this.contents[this.top] = s;
        ++this.top;
    }

    public void enter() {
        int n = this.top - 1;
        this.levels[n] = this.levels[n] + 1;
    }

    public boolean leave() {
        if (this.top > 0) {
            int n = this.top - 1;
            this.levels[n] = this.levels[n] - 1;
            if (this.levels[this.top - 1] == 0) {
                --this.top;
            }
            return this.top == 0;
        }
        throw new ArrayIndexOutOfBoundsException("Stack is empty !");
    }

    public int size() {
        return this.top;
    }

    public void clear() {
        this.top = 0;
    }

    public String top() {
        return this.contents[this.top - 1];
    }
}

