/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXToXMLWriter
extends DefaultHandler {
    private XMLTokenWriter xmlTokenWriter;

    public void init(XMLTokenWriter xmlTokenWriter) {
        this.xmlTokenWriter = xmlTokenWriter;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.xmlTokenWriter.flush();
        }
        catch (IOException ioExc) {
            throw new SAXException(ioExc);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.xmlTokenWriter.setPrefixForNamespace(prefix, uri);
        }
        catch (IOException ioExc) {
            throw new SAXException(ioExc);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.xmlTokenWriter.enter(uri, localName);
            int i = 0;
            while (i < atts.getLength()) {
                this.xmlTokenWriter.writeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                ++i;
            }
        }
        catch (IOException ioExc) {
            throw new SAXException(ioExc);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.xmlTokenWriter.leave();
        }
        catch (IOException ioExc) {
            throw new SAXException(ioExc);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlTokenWriter.writeContent(new String(ch, start, length));
        }
        catch (IOException ioExc) {
            throw new SAXException(ioExc);
        }
    }
}

