/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.tokenizer.AttributeHandler;
import com.sap.engine.lib.xml.parser.tokenizer.ElementTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterDOM;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDOMTokenWriter
implements XMLTokenWriterDOM {
    private ElementTokenWriter elementTokenWriter;
    private Document doc;
    private Element mainElement;

    public XMLDOMTokenWriter(DOMSource domSource) throws ParserConfigurationException {
        this.init(domSource);
    }

    public XMLDOMTokenWriter(Document doc) {
        this.init(doc);
    }

    public XMLDOMTokenWriter(Element mainElement) {
        this.init(mainElement);
    }

    @Override
    public void init(DOMSource domSource) throws ParserConfigurationException {
        Node node = domSource.getNode();
        if (node == null) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            domSource.setNode(doc);
            this.init(doc);
        } else if (node instanceof Document) {
            this.init((Document)node);
        } else if (node instanceof Element) {
            this.init((Element)node);
        }
    }

    @Override
    public void init(Document doc) {
        this.doc = doc;
        this.init(doc.getDocumentElement());
    }

    @Override
    public void init(Element mainElement) {
        if (mainElement != null) {
            this.doc = mainElement.getOwnerDocument();
        }
        this.mainElement = mainElement;
        this.elementTokenWriter = new ElementTokenWriter(this.doc, mainElement, null, null);
    }

    @Override
    public void appendNamespaces(Hashtable prefixToNamespaceMapping) {
        this.elementTokenWriter.appendNamespaces(prefixToNamespaceMapping);
    }

    @Override
    public void enter(String namespace, String localName) throws IOException {
        this.elementTokenWriter.enter(namespace, localName);
    }

    @Override
    public void leave() throws IOException, IllegalStateException {
        this.elementTokenWriter.leave();
        if (this.elementTokenWriter.isLeaved() && this.mainElement == null) {
            this.doc.appendChild(this.elementTokenWriter.getElement());
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        return this.elementTokenWriter.getPrefixForNamespace(namespace);
    }

    @Override
    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.elementTokenWriter.setPrefixForNamespace(prefix, namespace);
    }

    @Override
    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        this.elementTokenWriter.writeAttribute(namespace, name, value);
    }

    @Override
    public void writeContent(String content) throws IOException {
        this.elementTokenWriter.writeContent(content);
    }

    @Override
    public void writeContentCData(char[] chars) throws IOException {
        this.elementTokenWriter.writeContentCData(chars);
    }

    @Override
    public void writeContentCData(char[] chars, int offset, int count) throws IOException {
        this.elementTokenWriter.writeContentCData(chars, offset, count);
    }

    @Override
    public void writeContentCDataDirect(char[] chars) throws IOException {
        this.writeContent(new String(chars));
    }

    @Override
    public void writeContentCDataDirect(char[] chars, int offset, int count) throws IOException {
        this.writeContent(new String(chars, offset, count));
    }

    @Override
    public void writeComment(String comment) throws IOException {
        this.elementTokenWriter.writeComment(comment);
    }

    @Override
    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
        this.elementTokenWriter.writeXmlAttribute(name, value);
    }

    @Override
    public void setAttributeHandler(AttributeHandler handler) {
    }

    @Override
    public void init(OutputStream output) throws IOException {
    }

    @Override
    public void init(OutputStream output, String encoding) throws IOException {
    }

    @Override
    public void init(OutputStream output, String encoding, Hashtable defaultPrefixes) throws IOException {
    }

    @Override
    public void init(OutputStream output, Hashtable defaultPrefixes) throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeInitial() throws IOException {
    }

    @Override
    public void setProperty(String key, Object value) {
    }
}

