/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLToSAXReader {
    private XMLTokenReader xmlTokenReader;
    private ContentHandler contentHandler;
    private Hashtable charArrayToStringMap = new Hashtable();

    public void setXMLTokenReader(XMLTokenReader xmlTokenReader) {
        this.xmlTokenReader = xmlTokenReader;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void read() throws Exception {
        this.start();
        int state = -1;
        while ((state = this.xmlTokenReader.getState()) != 6) {
            if (state == 3) {
                this.readChars();
                continue;
            }
            if (state == 2) {
                this.readEndElement();
            } else if (state == 1) {
                this.readStartElement();
            }
            this.xmlTokenReader.next();
        }
        this.end();
    }

    private void end() throws Exception {
        this.xmlTokenReader.end();
        this.contentHandler.endDocument();
        this.charArrayToStringMap.clear();
    }

    private void start() throws Exception {
        this.xmlTokenReader.begin();
        this.contentHandler.startDocument();
    }

    private void readChars() throws Exception {
        CharArray chars = this.xmlTokenReader.getValuePassCharsCA();
        this.contentHandler.characters(chars.getData(), chars.getOffset(), chars.getSize());
    }

    private void readStartElement() throws SAXException {
        CharArray uri = this.xmlTokenReader.getURICharArray();
        CharArray localName = this.xmlTokenReader.getLocalNameCharArray();
        CharArray qName = this.xmlTokenReader.getQNameCharArray();
        Attributes attribs = this.xmlTokenReader.getAttributes();
        this.contentHandler.startElement(this.determineString(uri), this.determineString(localName), this.determineString(qName), attribs);
    }

    private void readEndElement() throws SAXException {
        CharArray uri = this.xmlTokenReader.getURICharArray();
        CharArray localName = this.xmlTokenReader.getLocalNameCharArray();
        CharArray qName = this.xmlTokenReader.getQNameCharArray();
        this.contentHandler.endElement(this.determineString(uri), this.determineString(localName), this.determineString(qName));
    }

    private String determineString(CharArray charArray) {
        String strValue = (String)this.charArrayToStringMap.get(charArray);
        if (strValue == null) {
            strValue = charArray.getStringFast();
            this.charArrayToStringMap.put(charArray, strValue);
        }
        return strValue;
    }
}

