/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.xml.sax.InputSource;

public class XMLTokenReaderFactory {
    private static XMLTokenReaderFactory factory;

    private XMLTokenReaderFactory() {
    }

    public static synchronized XMLTokenReaderFactory getInstance() {
        if (factory == null) {
            factory = new XMLTokenReaderFactory();
        }
        return factory;
    }

    public XMLTokenReader createReader() {
        return new XMLTokenReaderImpl();
    }

    public XMLTokenReader createReader(Map<?, ?> envMap) throws ParserException {
        XMLTokenReaderImpl reader = new XMLTokenReaderImpl();
        reader.begin();
        this.addEnvelopePrefixesInReader(reader.getNamespaceHandler(), envMap);
        return reader;
    }

    public XMLTokenReader createReader(InputStream input) {
        return new XMLTokenReaderImpl(input);
    }

    public XMLTokenReader createReader(InputStream input, Map envMap) throws ParserException {
        XMLTokenReaderImpl reader = new XMLTokenReaderImpl(input);
        reader.begin();
        this.addEnvelopePrefixesInReader(reader.getNamespaceHandler(), envMap);
        return reader;
    }

    public XMLTokenReader createReader(InputSource input) {
        return new XMLTokenReaderImpl(input);
    }

    public XMLTokenReader createReader(InputSource input, Map envMap) throws ParserException {
        XMLTokenReaderImpl reader = new XMLTokenReaderImpl(input);
        reader.begin();
        this.addEnvelopePrefixesInReader(reader.getNamespaceHandler(), envMap);
        return reader;
    }

    public XMLTokenReader createReader(Reader reader) {
        return new XMLTokenReaderImpl(reader);
    }

    public XMLTokenReader createReader(Reader reader, Map envMap) throws ParserException {
        XMLTokenReaderImpl newReader = new XMLTokenReaderImpl(reader);
        newReader.begin();
        this.addEnvelopePrefixesInReader(newReader.getNamespaceHandler(), envMap);
        return newReader;
    }

    private void addEnvelopePrefixesInReader(INamespaceHandler nsHandler, Map<?, ?> envMap) {
        if (envMap == null) {
            return;
        }
        for (String prefNS : envMap.keySet()) {
            String pref = (String)envMap.get(prefNS);
            nsHandler.add(new CharArray(pref), new CharArray(prefNS));
        }
    }

    public static XMLTokenReader newInstance() {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader();
    }

    public static XMLTokenReader newInstance(Map<?, ?> envMap) throws ParserException {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(envMap);
    }

    public static XMLTokenReader newInstance(InputStream input) {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(input);
    }

    public static XMLTokenReader newInstance(InputStream input, Map envMap) throws ParserException {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(input, envMap);
    }

    public static XMLTokenReader newInstance(InputSource input) {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(input);
    }

    public static XMLTokenReader newInstance(InputSource input, Map envMap) throws ParserException {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(input, envMap);
    }

    public static XMLTokenReader newInstance(Reader reader) {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(reader);
    }

    public XMLTokenReader newInstance(Reader reader, Map envMap) throws ParserException {
        XMLTokenReaderFactory factory = XMLTokenReaderFactory.getInstance();
        return factory.createReader(reader, envMap);
    }
}

