/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandlerEx;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.CharArrayStack;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderUtil;
import com.sap.engine.lib.xml.util.SymbolTable;
import com.sap.engine.lib.xsl.xslt.InternalAttribute;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTokenReaderImpl
extends EmptyDocHandler
implements XMLParserConstants,
XMLTokenReader {
    boolean ommitComments = true;
    private boolean shouldFakeEnd = false;
    private boolean textDeclAllowed = true;
    private boolean endOfRootReached = false;
    private InputStream xmlInputStream = null;
    private InputSource xmlInputSource = null;
    private Reader xmlReader = null;
    private int currentState = -1;
    private XMLParser parser = null;
    private NamespaceHandlerEx namespaceHandler = null;
    private CharArray uri = null;
    private CharArray localName = null;
    private CharArray qName = null;
    private CharArray charData = new CharArray();
    private InternalAttributeList attribs = new InternalAttributeList();
    private int depthReached = 0;
    private boolean append = false;
    private String encoding = null;
    private String xmlVer = null;
    private String piData = null;
    private String piTarget = null;
    private SymbolTable symbolTable = new SymbolTable(2048);
    private List<CharArray> prefixesOfEmptyElement;
    private AttributesImpl retAttrs = null;
    private Hashtable<CharArray, String> prefixMappings;
    private CharArray tempGetPrefix = new CharArray();
    private boolean bTrimWhitespaces = false;

    public String getPiData() {
        return this.piData;
    }

    public String getPiTarget() {
        return this.piTarget;
    }

    public INamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }

    public void setOmmitComments(boolean flag) {
        this.ommitComments = flag;
    }

    public boolean getOmmitComments() {
        return this.ommitComments;
    }

    public XMLTokenReaderImpl(InputSource xmlInputSource) {
        this();
        this.xmlInputSource = xmlInputSource;
    }

    public XMLTokenReaderImpl(XMLParser parser) {
        this();
        this.parser = parser;
    }

    public XMLTokenReaderImpl(InputStream xmlInputStream) {
        this();
        this.xmlInputStream = xmlInputStream;
    }

    public XMLTokenReaderImpl(Reader xmlReader) {
        this();
        this.xmlReader = xmlReader;
    }

    public XMLTokenReaderImpl() {
    }

    public void reuse(InputStream stream, InputSource inputSource, Reader reader) {
        this.xmlInputSource = inputSource;
        this.xmlReader = reader;
        this.xmlInputStream = stream;
        this.append = false;
        this.depthReached = 0;
        this.shouldFakeEnd = false;
        this.textDeclAllowed = true;
        this.endOfRootReached = false;
        this.xmlInputSource = null;
        this.currentState = -1;
        this.charData.clear();
    }

    @Override
    public void init(Reader reader) {
        this.reuse(null, null, reader);
    }

    @Override
    public void init(InputSource inputSource) {
        this.reuse(null, inputSource, null);
    }

    @Override
    public void init(InputStream stream) {
        this.reuse(stream, null, null);
    }

    @Override
    public int begin() throws ParserException {
        try {
            this.parser = this.getParser();
            this.namespaceHandler = (NamespaceHandlerEx)this.parser.getNamespaceHandler();
            this.shouldFakeEnd = false;
            this.endOfRootReached = false;
            if (this.xmlInputSource == null) {
                if (this.xmlReader != null) {
                    this.xmlInputSource = new InputSource(this.xmlReader);
                }
                if (this.xmlInputStream != null) {
                    this.xmlInputSource = new InputSource(this.xmlInputStream);
                }
            }
            if (this.xmlReader != null) {
                this.setProperty("http://sap.com/xml/soap-input", "false");
            }
            this.parser.activeParse(this.xmlInputSource, this);
            this.currentState = 0;
            return this.currentState;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int next() throws ParserException {
        try {
            if (!this.append && this.charData.getData().length > 2048) {
                this.charData = new CharArray(10, 2048);
            }
            if (this.parser.getDocFinished()) {
                this.currentState = 6;
                this.parser.finalizeActiveParse();
                return 6;
            }
            if (this.shouldFakeEnd) {
                this.shouldFakeEnd = false;
                this.currentState = 2;
                --this.depthReached;
                return this.currentState;
            }
            this.prefixesOfEmptyElement = null;
            int i = this.parser.checkMarkup();
            switch (i) {
                case 2: {
                    this.parser.scanPI(this.textDeclAllowed);
                    this.textDeclAllowed = false;
                    return 4;
                }
                case 3: {
                    this.parser.scanElement();
                    return 1;
                }
                case 1: {
                    this.parser.scanComment();
                    if (this.ommitComments) {
                        return this.next();
                    }
                    return 5;
                }
                case 8: {
                    this.parser.scanCharData();
                    return 3;
                }
                case 9: {
                    this.parser.scanCDSect();
                    return 3;
                }
                case 10: {
                    this.parser.scanEndTag();
                    if (this.depthReached < 1) {
                        this.endOfRootReached = true;
                        this.parser.finalizeActiveScan();
                    }
                    return 2;
                }
                case 16: {
                    this.parser.handleContentReference(false);
                    return 3;
                }
                case 17: {
                    this.parser.scanDTD();
                    if (this.parser.bSoapProcessing) {
                        return this.next();
                    }
                    return 7;
                }
            }
            throw new ParserException(" Unrecognized case: " + i, -1, 0);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    @Override
    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        this.attribs.clear();
        this.retAttrs = null;
        this.charData.setSize(0);
        ++this.depthReached;
        if (this.namespaceHandler.isPrefMappingChangedAndClear()) {
            this.prefixMappings = this.namespaceHandler.getNamespaceMappings();
        }
    }

    @Override
    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        this.attribs.addAttribute(uri, prefix, qname, localName, value);
    }

    @Override
    public void startElementEnd(boolean isEmpty) throws Exception {
        this.currentState = 1;
        if (isEmpty) {
            this.shouldFakeEnd = true;
            this.prefixesOfEmptyElement = this.namespaceHandler.getPrefixesOnLastStartElement();
        }
    }

    @Override
    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        if (!isEmpty) {
            this.currentState = 2;
            --this.depthReached;
        }
        if (this.namespaceHandler.isPrefMappingChangedAndClear()) {
            this.prefixMappings = this.namespaceHandler.getNamespaceMappings();
        }
    }

    @Override
    public void startDocument() throws Exception {
        this.currentState = 0;
    }

    @Override
    public void endDocument() throws Exception {
        this.currentState = 6;
    }

    @Override
    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        if (this.append) {
            this.charData.append(carr);
        } else {
            this.charData.set(carr);
        }
        this.currentState = 3;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getXmlVer() {
        return this.xmlVer;
    }

    @Override
    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
        this.xmlVer = version;
        this.encoding = encoding;
    }

    @Override
    public void onPI(CharArray target, CharArray data) throws Exception {
        if (!this.parser.bSoapProcessing) {
            this.currentState = 4;
            this.piTarget = target.getString();
            this.piData = data.getString();
        }
    }

    @Override
    public void onComment(CharArray text) throws Exception {
        if (!this.ommitComments) {
            this.currentState = 5;
            this.charData.set(text);
        }
    }

    @Override
    public void onCDSect(CharArray text) throws Exception {
        if (this.append) {
            this.charData.append(text);
        } else {
            this.charData.set(text);
        }
        this.currentState = 3;
    }

    @Override
    public void onDTDElement(CharArray name, CharArray model) throws Exception {
        if (!this.parser.bSoapProcessing) {
            this.currentState = 7;
        }
    }

    @Override
    public void onDTDAttListStart(CharArray name) throws Exception {
    }

    @Override
    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
    }

    @Override
    public void onDTDAttListEnd() throws Exception {
    }

    @Override
    public void onDTDEntity(Entity entity) throws Exception {
        if (!this.parser.bSoapProcessing) {
            this.currentState = 7;
        }
    }

    @Override
    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
        if (!this.parser.bSoapProcessing) {
            this.currentState = 7;
        }
    }

    @Override
    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    @Override
    public void endDTD() throws Exception {
    }

    @Override
    public void onContentReference(Reference ref) throws Exception {
    }

    @Override
    public void end() throws ParserException {
        if (this.currentState != 6) {
            throw new ParserException("EOF not reached yet!", 0, 0);
        }
        try {
            this.parser.finalizeActiveParse();
        }
        catch (Exception e) {
            throw new ParserException(e.toString(), 0, 0);
        }
    }

    @Override
    public int getState() {
        return this.currentState;
    }

    @Override
    public String getQName() {
        return this.qName.getString(this.symbolTable);
    }

    @Override
    public CharArray getQNameCharArray() {
        return this.qName;
    }

    @Override
    public String getLocalName() {
        return this.localName.getString(this.symbolTable);
    }

    @Override
    public CharArray getLocalNameCharArray() {
        return this.localName;
    }

    @Override
    public String getURI() {
        return this.uri.getString(this.symbolTable);
    }

    @Override
    public CharArray getURICharArray() {
        return this.uri;
    }

    @Override
    public Attributes getAttributes() {
        if (this.currentState != 1) {
            return null;
        }
        if (this.retAttrs != null) {
            return this.retAttrs;
        }
        AttributesImpl attr = new AttributesImpl();
        int i = 0;
        while (i < this.attribs.size()) {
            InternalAttribute ia = this.attribs.get(i);
            attr.addAttribute(ia.uri == null ? null : ia.uri.getString(this.symbolTable), ia.localName.getString(this.symbolTable), ia.qname.getString(this.symbolTable), "CDATA", ia.value.getString(this.symbolTable));
            ++i;
        }
        this.retAttrs = attr;
        return this.retAttrs;
    }

    @Override
    public InternalAttributeList getInternalAttributeList() {
        return this.attribs;
    }

    @Override
    public String getValue() {
        return this.charData.getStringFast();
    }

    @Override
    public CharArray getValueCharArray() {
        return this.charData;
    }

    @Override
    public CharArray getValuePassCharsCA() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        if (this.bTrimWhitespaces) {
            this.charData.trim();
        }
        return this.charData;
    }

    @Override
    public String getValuePassChars() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        if (this.bTrimWhitespaces) {
            this.charData.trim();
        }
        return this.charData.getStringFast();
    }

    @Override
    public boolean isWhitespace() {
        return this.charData.isWhitespace();
    }

    public Element getDOMRepresentation(Element element) throws ParserException {
        return XMLTokenReaderUtil.getDOMRepresentation(this, element);
    }

    @Override
    public Element getDOMRepresentation(Document document) throws ParserException {
        if (this.getState() != 1) {
            return null;
        }
        Element element = document.createElementNS(this.getURI(), this.getQName());
        return this.getDOMRepresentation(element);
    }

    @Override
    public void writeTo(Writer writer) throws ParserException, IOException {
        XMLTokenReaderUtil.copyReader2Writer(this, writer);
    }

    @Override
    public int moveToNextElementStart() throws ParserException {
        int code;
        do {
            if ((code = this.next()) != 1) continue;
            return 1;
        } while (code != 6);
        return 6;
    }

    @Override
    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
    }

    @Override
    public void endPrefixMapping(CharArray prefix) throws Exception {
    }

    public XMLParser getParser() throws ParserException {
        if (this.parser == null) {
            this.parser = new XMLParser();
            this.parser.setSoapProcessing(true);
            this.parser.setNamespaces(true);
        }
        return this.parser;
    }

    public void setParser(XMLParser parser) {
        this.parser = parser;
    }

    @Override
    public String getPrefixMapping(String prefix) {
        this.tempGetPrefix.set(prefix);
        return this.prefixMappings.get(this.tempGetPrefix);
    }

    @Override
    public void passChars() throws ParserException {
        while (this.currentState == 3) {
            this.next();
        }
    }

    @Override
    public String getParentElement() {
        CharArrayStack stack = this.parser.getElementStack();
        if (this.currentState == 1) {
            CharArray current = new CharArray(stack.getTop());
            stack.matchTop(new CharArray(current));
            if (stack.isEmpty()) {
                stack.put(current);
                return null;
            }
            char[] top = stack.getTop();
            stack.put(current);
            return new String(top);
        }
        if (stack.isEmpty()) {
            return null;
        }
        return new String(stack.getTop());
    }

    @Override
    public int getCurrentLevel() {
        return this.depthReached;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) throws ParserException {
        this.getParser().setEntityResolver(entityResolver);
    }

    @Override
    public void setProperty(String key, Object value) {
        try {
            if (key.equals("http://sap.com/xml/soap-input") && value != null && value instanceof String) {
                if ("true".equalsIgnoreCase((String)value)) {
                    this.getParser().setSoapProcessing(true);
                } else {
                    this.getParser().setSoapProcessing(false);
                }
            }
            if (key.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
                this.bTrimWhitespaces = (Boolean)value;
            } else {
                this.getParser().setProperty(key, value);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Property not supported.", e);
        }
    }

    @Override
    public Map<String, String> getNamespaceMappings() {
        Hashtable<CharArray, String> ht = this.prefixMappings;
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration<CharArray> en = ht.keys();
        while (en.hasMoreElements()) {
            CharArray k = en.nextElement();
            String v = ht.get(k);
            res.put(k.getString(this.symbolTable), v);
        }
        return res;
    }

    @Override
    public List<String> getPrefixesOnLastStartElement() {
        List<CharArray> charArrList = this.prefixesOfEmptyElement != null ? this.prefixesOfEmptyElement : this.namespaceHandler.getPrefixesOnLastStartElement();
        if (charArrList.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> res = new ArrayList<String>(1);
        for (CharArray prefix : charArrList) {
            if (NamespaceHandlerEx.defaultPrefixName == prefix) {
                res.add("");
                continue;
            }
            res.add(prefix.getString(this.symbolTable));
        }
        return res;
    }

    @Override
    public List<String[]> getEndedPrefixMappings() {
        return this.namespaceHandler.getEndedPrefixMappings();
    }
}

