/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class XMLTokenReaderUtil {
    public static Element getDOMRepresentation(XMLTokenReader reader, Element element) throws ParserException {
        if (reader == null || element == null) {
            throw new IllegalArgumentException("Passed argument can no be null.");
        }
        if (reader.getState() != 1) {
            return null;
        }
        Map<String, String> prefixMappings = reader.getNamespaceMappings();
        Set<String> keySet = prefixMappings.keySet();
        for (String key : keySet) {
            String namespace = prefixMappings.get(key);
            if (namespace.length() == 0) continue;
            if (key.length() == 0) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
                continue;
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + key, namespace);
        }
        return XMLTokenReaderUtil.fillElement(reader, element);
    }

    private static Element fillElement(XMLTokenReader reader, Element element) throws ParserException {
        Attributes attrs = reader.getAttributes();
        int attrsLeght = attrs.getLength();
        int i = 0;
        while (i < attrsLeght) {
            String attribUri = attrs.getURI(i);
            String attribQName = attrs.getQName(i);
            String attribValue = attrs.getValue(i);
            if (attribQName.equals("xmlns")) {
                attribUri = "http://www.w3.org/2000/xmlns/";
            }
            element.setAttributeNS(attribUri, attribQName, attribValue);
            ++i;
        }
        block8: while (true) {
            int code = reader.next();
            switch (code) {
                case 5: {
                    element.appendChild(element.getOwnerDocument().createComment(reader.getValue()));
                    continue block8;
                }
                case 3: {
                    element.appendChild(element.getOwnerDocument().createTextNode(reader.getValue()));
                    continue block8;
                }
                case 1: {
                    Element child = element.getOwnerDocument().createElementNS(reader.getURI(), reader.getQName());
                    element.appendChild(XMLTokenReaderUtil.fillElement(reader, child));
                    continue block8;
                }
                case 2: {
                    return element;
                }
                case 6: {
                    throw new ParserException("Unexpexted EOF.", 0, 0);
                }
            }
        }
    }

    public static void copyReader2Writer(XMLTokenReader reader, Writer writer) throws ParserException, IOException {
        if (reader.getState() != 3 && reader.getState() != 1) {
            throw new ParserException("Invalid reader state.", 0, 0);
        }
        if (reader.getState() != 3) {
            HashMap<String, String> effPrefMapsAttr = new HashMap<String, String>();
            Map<String, String> prefixMappings = reader.getNamespaceMappings();
            Set<String> nsKeySet = prefixMappings.keySet();
            for (String nsKey : nsKeySet) {
                String namespace = prefixMappings.get(nsKey);
                if (namespace.length() == 0) continue;
                if (nsKey.length() == 0) {
                    effPrefMapsAttr.put("xmlns", namespace);
                    continue;
                }
                effPrefMapsAttr.put("xmlns:" + nsKey, namespace);
            }
            writer.write(60);
            CharArray charArr = reader.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(32);
            Attributes atts = reader.getAttributes();
            if (atts != null) {
                int i = 0;
                while (i < atts.getLength()) {
                    if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i)) && !"xmlns".equals(atts.getLocalName(i))) {
                        writer.write(atts.getQName(i));
                        writer.write("='");
                        writer.write(atts.getValue(i));
                        writer.write("' ");
                    } else {
                        effPrefMapsAttr.put(atts.getQName(i), atts.getValue(i));
                    }
                    ++i;
                }
            }
            Set keySet = effPrefMapsAttr.keySet();
            for (String prefD : keySet) {
                writer.write(String.valueOf(prefD) + "='");
                writer.write((String)effPrefMapsAttr.get(prefD));
                writer.write("' ");
            }
            writer.write(62);
            int level = 0;
            block10: while (true) {
                int code = reader.next();
                switch (code) {
                    case 5: {
                        XMLTokenReaderUtil.writeCharsOrComment(reader, writer);
                        continue block10;
                    }
                    case 3: {
                        XMLTokenReaderUtil.writeCharsOrComment(reader, writer);
                        continue block10;
                    }
                    case 1: {
                        XMLTokenReaderUtil.writeStartEndElement(reader, writer);
                        ++level;
                        continue block10;
                    }
                    case 2: {
                        XMLTokenReaderUtil.writeStartEndElement(reader, writer);
                        if (level == 0) {
                            writer.flush();
                            return;
                        }
                        --level;
                        continue block10;
                    }
                    case 6: {
                        throw new ParserException("Unexpexted EOF.", 0, 0);
                    }
                }
            }
        }
        XMLTokenReaderUtil.writeCharsOrComment(reader, writer);
        writer.flush();
    }

    private static void writeCharsOrComment(XMLTokenReader reader, Writer writer) throws IOException {
        CharArray charArr = reader.getValueCharArray();
        if (reader.getState() == 5) {
            writer.write("<!--");
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write("-->");
        } else {
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
        }
    }

    private static void writeStartEndElement(XMLTokenReader reader, Writer writer) throws IOException {
        if (reader.getState() == 1) {
            writer.write(60);
            CharArray charArr = reader.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(32);
            Attributes atts = reader.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                writer.write(atts.getQName(i));
                writer.write("='");
                writer.write(atts.getValue(i));
                writer.write("' ");
                ++i;
            }
            writer.write(62);
        } else {
            writer.write("</");
            CharArray charArr = reader.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(62);
        }
    }

    public static void copyTokenReader2TokenWriter(XMLTokenReader reader, XMLTokenWriter writer) throws ParserException, IOException {
        if (reader.getState() != 3 && reader.getState() != 1) {
            throw new ParserException("Invalid reader state.", 0, 0);
        }
        if (reader.getState() != 3) {
            Map<String, String> prefixMappings = reader.getNamespaceMappings();
            Set<String> nsKeySet = prefixMappings.keySet();
            for (String nsKey : nsKeySet) {
                String namespace = prefixMappings.get(nsKey);
                if (namespace.length() <= 0) continue;
                writer.setPrefixForNamespace(nsKey, namespace);
            }
            writer.enter(reader.getURI(), reader.getLocalName());
            Attributes atts = reader.getAttributes();
            if (atts != null) {
                int i = 0;
                while (i < atts.getLength()) {
                    if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i)) && !"xmlns".equals(atts.getLocalName(i))) {
                        writer.writeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                    }
                    ++i;
                }
            }
            int level = 0;
            block9: while (true) {
                int code = reader.next();
                switch (code) {
                    case 5: {
                        writer.writeComment(reader.getValue());
                        continue block9;
                    }
                    case 3: {
                        writer.writeContent(reader.getValue());
                        continue block9;
                    }
                    case 1: {
                        writer.enter(reader.getURI(), reader.getLocalName());
                        atts = reader.getAttributes();
                        int i = 0;
                        while (atts != null && i < atts.getLength()) {
                            if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i)) && !"xmlns".equals(atts.getLocalName(i))) {
                                writer.writeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                            } else if ("xmlns".equals(atts.getLocalName(i))) {
                                writer.setPrefixForNamespace("", atts.getValue(i));
                            } else {
                                writer.setPrefixForNamespace(atts.getLocalName(i), atts.getValue(i));
                            }
                            ++i;
                        }
                        ++level;
                        continue block9;
                    }
                    case 2: {
                        writer.leave();
                        if (level == 0) {
                            return;
                        }
                        --level;
                        continue block9;
                    }
                    case 6: {
                        throw new ParserException("Unexpexted EOF.", 0, 0);
                    }
                }
            }
        }
        writer.writeContent(reader.getValue());
    }
}

