/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.AttributeHandler;
import com.sap.engine.lib.xml.parser.tokenizer.PHSet;
import com.sap.engine.lib.xml.parser.tokenizer.PrefixHolder;
import com.sap.engine.lib.xml.parser.tokenizer.StringStacker;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.util.SymbolTable;
import com.sap.engine.lib.xsl.xslt.output.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLTokenWriterImpl
implements XMLTokenWriter {
    public char DELIMETER_CHAR = (char)39;
    private String encoding;
    private String currentName;
    private String namespace;
    private HashMap currentPrefixes;
    private int generatedNSIndex;
    private StringStacker stack;
    private String[] attrNames;
    private String[] attrValues;
    private String[] attrUris;
    private int attrCount;
    private ArrayList perm;
    private boolean indent;
    StringBuffer indentString;
    private int INDENTCOUNT = 2;
    private char[] indentPiece;
    private int indentLevel = 0;
    private boolean textContent;
    private Encoder enc;
    private static final String PREF = "yq";
    private PHSet allnamespaces;
    private static final String[] CH_TO_ENT = new String[256];
    private SymbolTable symbolTable = new SymbolTable(1024);
    private CharArray caCurrentName = new CharArray();
    private PrefixHolder[] cache = new PrefixHolder[128];
    private int ctop = 0;
    private AttributeHandler handler;

    static {
        XMLTokenWriterImpl.CH_TO_ENT[38] = "&amp;";
        XMLTokenWriterImpl.CH_TO_ENT[39] = "&apos;";
        XMLTokenWriterImpl.CH_TO_ENT[34] = "&quot;";
        XMLTokenWriterImpl.CH_TO_ENT[60] = "&lt;";
        XMLTokenWriterImpl.CH_TO_ENT[62] = "&gt;";
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public XMLTokenWriterImpl() {
        this.indentPiece = new char[this.INDENTCOUNT];
        int i = 0;
        while (i < this.INDENTCOUNT) {
            this.indentPiece[i] = 32;
            ++i;
        }
        this.indent = false;
        this.allnamespaces = new PHSet();
        this.currentPrefixes = new HashMap();
        this.stack = new StringStacker();
        this.attrNames = new String[512];
        this.attrValues = new String[512];
        this.attrUris = new String[512];
        this.attrCount = 0;
        this.perm = new ArrayList();
        this.indentString = new StringBuffer();
        this.enc = new Encoder();
    }

    private String getPrefixInternal(String namespace) {
        int i = 0;
        while (i < this.allnamespaces.currentSize) {
            PrefixHolder ph = this.allnamespaces.get(i);
            if (ph.namespace.equals(namespace)) {
                return ph.top();
            }
            ++i;
        }
        return null;
    }

    private void updateNamespacesDown() {
        String prefix;
        int size = this.allnamespaces.size();
        PrefixHolder[] arr = this.allnamespaces.getContent();
        int i = 0;
        while (i < size) {
            PrefixHolder ph = arr[i];
            if (this.currentPrefixes.containsKey(ph.namespace)) {
                prefix = (String)this.currentPrefixes.get(ph.namespace);
                ph.enter(prefix);
                this.attrNames[this.attrCount] = prefix.length() != 0 ? "xmlns:".concat(prefix) : "xmlns";
                this.attrValues[this.attrCount] = ph.namespace;
                this.attrUris[this.attrCount] = null;
                ++this.attrCount;
                this.currentPrefixes.remove(ph.namespace);
            } else {
                ph.enter();
            }
            ++i;
        }
        for (String namespace : this.currentPrefixes.keySet()) {
            prefix = (String)this.currentPrefixes.get(namespace);
            PrefixHolder ph = this.getPrefixHolder(namespace);
            this.allnamespaces.add(ph);
            ph.enter(prefix);
            this.attrNames[this.attrCount] = prefix.length() != 0 ? "xmlns:".concat(prefix) : "xmlns";
            this.attrValues[this.attrCount] = namespace;
            ++this.attrCount;
        }
        this.currentPrefixes.clear();
    }

    private void updateNamespaceUp() {
        int size = this.allnamespaces.size();
        PrefixHolder[] arr = this.allnamespaces.getContent();
        int newSize = 0;
        int i = 0;
        while (i < size) {
            if (arr[i].leave()) {
                arr[i] = null;
            } else {
                if (i != newSize) {
                    arr[newSize] = arr[i];
                    arr[i] = null;
                }
                ++newSize;
            }
            ++i;
        }
        this.allnamespaces.setSize(newSize);
    }

    private String generateNSPrefix(String namespace) {
        String prefix = PREF + String.valueOf(this.generatedNSIndex);
        ++this.generatedNSIndex;
        this.currentPrefixes.put(namespace, prefix);
        return prefix;
    }

    private void checkCustomPrefix(String pref) {
    }

    private void appendAttributes() throws IOException {
        int i = 0;
        while (i < this.attrCount) {
            if (this.attrValues[i] != null && this.attrNames[i] != null) {
                this.enc.out(' ');
                this.enc.out(this.attrNames[i]);
                this.enc.out('=');
                this.enc.out(this.DELIMETER_CHAR);
                this.enc.outAttribute(this.attrValues[i], this.DELIMETER_CHAR);
                this.enc.out(this.DELIMETER_CHAR);
            }
            ++i;
        }
        this.attrCount = 0;
    }

    private void enterIndent() {
        ++this.indentLevel;
        this.indentString.append(this.indentPiece);
    }

    private void leaveIndent() {
        --this.indentLevel;
        int perm = this.indentString.length();
        this.indentString.setLength(perm - this.INDENTCOUNT);
    }

    private void writeTagOpen() throws IOException {
        if (this.namespace != null && this.namespace.length() != 0) {
            String prefix = (String)this.currentPrefixes.get(this.namespace);
            if (prefix == null && ((prefix = this.getPrefixInternal(this.namespace)) == null || this.currentPrefixes.containsValue(prefix))) {
                prefix = this.generateNSPrefix(this.namespace);
            }
            if (prefix.length() > 0) {
                this.caCurrentName.set(prefix);
                this.caCurrentName.append(':');
                this.caCurrentName.append(this.currentName);
            } else {
                this.caCurrentName.set(this.currentName);
            }
            this.currentName = this.caCurrentName.getString(this.symbolTable);
        }
        this.updateAttributePrefixes();
        this.updateNamespacesDown();
        if (this.indent && !this.textContent) {
            this.enc.out('\n');
            this.enc.out(this.indentString.toString());
        }
        this.enc.out('<');
        this.enc.out(this.currentName);
        this.stack.push(this.currentName);
        if (this.handler != null) {
            this.attrCount = this.handler.handleAttributes(this.attrNames, this.attrValues, this.attrUris, this.attrCount, this.currentName, this.namespace, this);
        }
        this.appendAttributes();
        this.enc.out('>');
        this.currentName = null;
        this.namespace = null;
        if (this.indent) {
            this.enterIndent();
        }
    }

    private void writeTagClose() throws IOException {
        if (this.indent) {
            this.leaveIndent();
        }
        if (this.indent && !this.textContent) {
            this.enc.out('\n');
            this.enc.out(this.indentString.toString());
        }
        String elementName = this.stack.pop();
        this.enc.out("</");
        this.enc.out(elementName);
        this.enc.out('>');
        this.textContent = false;
    }

    @Override
    public void init(OutputStream output, Hashtable defaultPrefixes) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indentLevel = 0;
        this.indent = false;
        this.enc.init(output);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        this.appendNamespaces(defaultPrefixes);
    }

    @Override
    public void appendNamespaces(Hashtable hash) {
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.getPrefixInternal(key) != null) continue;
            String value = (String)hash.get(key);
            this.checkCustomPrefix(value);
            PrefixHolder ph = this.getPrefixHolder(key);
            ph.enter(value);
            this.allnamespaces.add(ph);
        }
    }

    @Override
    public void init(OutputStream output) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indentLevel = 0;
        this.indent = false;
        this.enc.init(output);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        this.encoding = "utf-8";
    }

    @Override
    public void init(OutputStream output, String encoding) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indent = false;
        this.indentLevel = 0;
        this.enc.init(output, encoding);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        this.encoding = encoding.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void init(OutputStream output, String encoding, Hashtable defaultPrefixes) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indent = false;
        this.indentLevel = 0;
        this.enc.init(output, encoding);
        this.encoding = encoding.toUpperCase(Locale.ENGLISH);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        this.appendNamespaces(defaultPrefixes);
    }

    @Override
    public void writeInitial() throws IOException {
        this.enc.out("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
    }

    @Override
    public void enter(String namespace, String localName) throws IOException {
        if (this.currentName != null) {
            this.textContent = false;
            this.writeTagOpen();
        }
        this.currentName = localName;
        this.namespace = namespace;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.enc.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    @Override
    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        if (this.currentPrefixes.get(namespace) != null) {
            return (String)this.currentPrefixes.get(namespace);
        }
        return this.getPrefixInternal(namespace);
    }

    @Override
    public void leave() throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.writeTagClose();
        this.updateNamespaceUp();
    }

    @Override
    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.checkCustomPrefix(prefix);
        this.currentPrefixes.put(namespace, prefix);
    }

    private void updateAttributePrefixes() {
        int i = 0;
        while (i < this.attrCount) {
            String namespace = this.attrUris[i];
            if (namespace != null && namespace.length() != 0) {
                String prefix = this.getPrefixInternal(namespace);
                if (prefix == null && (prefix = (String)this.currentPrefixes.get(namespace)) == null) {
                    prefix = this.generateNSPrefix(namespace);
                }
                this.attrNames[i] = String.valueOf(prefix) + ":" + this.attrNames[i];
            }
            ++i;
        }
    }

    @Override
    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        this.attrNames[this.attrCount] = name;
        this.attrValues[this.attrCount] = value;
        this.attrUris[this.attrCount] = namespace;
        ++this.attrCount;
    }

    @Override
    public void writeComment(String comment) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            if (this.indent) {
                this.textContent = false;
                this.enc.out('\n');
            }
        }
        this.enc.out("<!-- ");
        this.enc.out(comment);
        this.enc.out(" -->");
        if (this.indent) {
            this.enc.out('\n');
        }
    }

    @Override
    public void writeContentCData(char[] content) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.writeXMLEscaped(content);
    }

    @Override
    public void writeContentCData(char[] chars, int offset, int count) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.enc.outEscaped(chars, offset, count);
    }

    @Override
    public void writeContentCDataDirect(char[] chars, int offset, int count) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.enc.out(chars, offset, count);
    }

    @Override
    public void writeContentCDataDirect(char[] chars) throws IOException {
        this.writeContentCDataDirect(chars, 0, chars.length);
    }

    @Override
    public void writeContent(String content) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        } else if (content.length() != 0) {
            this.textContent = true;
        }
        this.enc.outEscaped(content);
    }

    @Override
    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
    }

    @Override
    public void close() throws IOException {
        this.enc.close();
    }

    public void writeStatistics() {
    }

    private void writeXMLEscaped(char[] s, int offset, int count) throws IOException {
        this.enc.outEscaped(s, offset, count);
    }

    private void writeXMLEscaped(char[] s) throws IOException {
        this.enc.outEscaped(s, 0, s.length);
    }

    private PrefixHolder getPrefixHolder(String namespace) {
        if (this.ctop == 0) {
            return new PrefixHolder(namespace);
        }
        --this.ctop;
        this.cache[this.ctop].namespace = namespace;
        return this.cache[this.ctop];
    }

    private void returnPrefixHolder(PrefixHolder ph) {
        if (this.ctop < this.cache.length) {
            ph.init();
            this.cache[this.ctop] = ph;
            ++this.ctop;
        }
    }

    public void outputElementWithNoIndent(Element elem) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
        }
        if (this.indent) {
            this.enc.out('\n');
            this.enc.out(this.indentString.toString());
        }
        boolean indentBcp = this.indent;
        this.indent = false;
        XMLTokenWriterImpl.outputDomToWriter(this, elem);
        this.indent = indentBcp;
    }

    public static void outputDomToWriter(XMLTokenWriter writer, Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 5: {
                writer.writeContent(node.getNodeValue());
                break;
            }
            case 8: {
                writer.writeComment(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                String localName = element.getLocalName();
                if (localName == null) {
                    localName = element.getNodeName();
                }
                String namespace = element.getNamespaceURI();
                writer.enter(namespace, localName);
                NamedNodeMap attributes = element.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr attribute = (Attr)attributes.item(i);
                    if (attribute.getName().startsWith("xmlns:")) {
                        String dnamespace;
                        String dprefix = DOM.qnameToLocalName(attribute.getName());
                        if (!dprefix.equals(writer.getPrefixForNamespace(dnamespace = attribute.getValue()))) {
                            writer.setPrefixForNamespace(dprefix, dnamespace);
                        }
                    } else if ("xmlns".equals(attribute.getName())) {
                        String dnamespace = attribute.getValue();
                        if (!"".equals(writer.getPrefixForNamespace(dnamespace))) {
                            writer.setPrefixForNamespace("", dnamespace);
                        }
                    } else {
                        writer.writeAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
                    }
                    ++i;
                }
                Node child = element.getFirstChild();
                while (child != null) {
                    XMLTokenWriterImpl.outputDomToWriter(writer, child);
                    child = child.getNextSibling();
                }
                writer.leave();
            }
        }
    }

    @Override
    public void setAttributeHandler(AttributeHandler handler) {
        this.handler = handler;
    }

    public static void registerNamespaces(XMLTokenWriter writer, Set<String> nss) throws IOException {
        Iterator<String> itr = nss.iterator();
        String pref = "rn";
        int count = 0;
        while (itr.hasNext()) {
            String ns = itr.next();
            if (ns.length() <= 0 || writer.getPrefixForNamespace(ns) != null) continue;
            writer.setPrefixForNamespace(String.valueOf(pref) + count++, ns);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        if ("indent".equals(key) && value != null && value instanceof String) {
            if ("true".equalsIgnoreCase((String)value)) {
                this.setIndent(true);
            } else {
                this.setIndent(false);
            }
        }
    }
}

