/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.signature.CryptographicProvider;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import java.io.IOException;
import java.security.Provider;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configurator {
    static Hashtable providers = new Hashtable(4);
    static String defaultProvider = "IAIK";
    static CryptographicProvider currentProvider = null;
    public static String iniFile = "config.xml";

    static {
        Configurator.init();
        if (currentProvider == null) {
            defaultProvider = "IAIK";
            currentProvider = (CryptographicProvider)providers.get(defaultProvider);
        }
    }

    public static void init() {
        try {
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document doc = builder.parse(Configurator.class.getResourceAsStream(iniFile));
            Element root = doc.getDocumentElement();
            if ("XMLSecurity".equals(root.getNodeName())) {
                defaultProvider = root.getAttribute("defaultProvider");
            }
            NodeList pros = doc.getElementsByTagName("Provider");
            providers.clear();
            int i = 0;
            while (i < pros.getLength()) {
                CryptographicProvider cp = new CryptographicProvider(pros.item(i));
                providers.put(cp.getJceString(), cp);
                ++i;
            }
            currentProvider = (CryptographicProvider)providers.get(defaultProvider);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            SignatureException.dump("Unable to load configuration", ex);
            Configurator.initConstants();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            SignatureException.dump("Unable to load configuration", ex);
            Configurator.initConstants();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            SignatureException.dump("Unable to load configuration", ex);
            Configurator.initConstants();
        }
    }

    public static void initConstants() {
        CryptographicProvider.initConstants(providers);
    }

    public static void setAlgorithmProvider(String providerName) {
        defaultProvider = providerName;
        SignatureContext.nullCryptographicPool();
        currentProvider = (CryptographicProvider)providers.get(providerName);
    }

    public static void setAlgorithmProvider(String providerName, Provider provider) {
        Configurator.setAlgorithmProvider(providerName);
    }

    public static Map getCipherAlgorithms() throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getCipherAlgorithms();
    }

    public static Map getSignatureAlgorithms() throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getSignatureAlgorithms();
    }

    public static Map getDigestAlgorithms() throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getDigestAlgorithms();
    }

    public static Map getIVLengths() throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getIVLengths();
    }

    public static int getIVLength(String algorithmURI) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getIVLength(algorithmURI);
    }

    public static String getDigestURIFromJCE(String jceName) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getDigestURIFromJCE(jceName);
    }

    public static String getSignatureURIFromJCE(String jceName) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getSignatureURIFromJCE(jceName);
    }

    public static String getCipherURIFromJCE(String jceName) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getCipherURIFromJCE(jceName);
    }

    public static String getDigestAlgorithm(String uri) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getDigestAlgorithm(uri);
    }

    public static String getSignatureAlgorithm(String uri) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getSignatureAlgorithm(uri);
    }

    public static String getCipherAlgorithm(String uri) throws SignatureException {
        if (currentProvider == null) {
            throw new SignatureException("No such provider configured. See config.xml:" + defaultProvider, new Object[]{defaultProvider});
        }
        return currentProvider.getCipherAlgorithm(uri);
    }

    public static String getProviderName() {
        return defaultProvider;
    }
}

