/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class CryptographicPool {
    public int MAX_SIZE = 20;
    int signatureSize = 0;
    Hashtable signatures = new Hashtable(4);
    int cipherSize = 0;
    Hashtable ciphers = new Hashtable(4);
    int messageSize = 0;
    Hashtable messageDigests = new Hashtable(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature getSignatureFromPool(String algorithmURI) throws NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        String algorithm = Configurator.getSignatureAlgorithm(algorithmURI);
        if (algorithm != null) {
            Hashtable hashtable = this.signatures;
            synchronized (hashtable) {
                int i;
                Vector v = (Vector)this.signatures.get(algorithm);
                int n = i = v != null ? v.size() : 0;
                if (i > 0) {
                    --this.signatureSize;
                    return (Signature)v.remove(i - 1);
                }
            }
        }
        throw new SignatureException("Unknown signature with algorithmURI: " + algorithmURI + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSignature(Signature signature) {
        if (signature == null) {
            return;
        }
        String alg = signature.getAlgorithm();
        Hashtable hashtable = this.signatures;
        synchronized (hashtable) {
            if (this.signatureSize < this.MAX_SIZE) {
                Vector<Signature> v = (Vector<Signature>)this.signatures.get(alg);
                if (v == null) {
                    v = new Vector<Signature>(4);
                    this.signatures.put(alg, v);
                }
                v.addElement(signature);
                ++this.signatureSize;
            }
        }
    }

    private String constructCipherRequest(String algorithmURI, String cryptMode, String cryptPadding) throws SignatureException {
        String algorithm = Configurator.getCipherAlgorithm(algorithmURI);
        if (algorithm == null || cryptMode == null || cryptPadding == null) {
            throw new SignatureException("Unknown algorithm URI: " + algorithmURI + ".");
        }
        if ("CBC".equals(cryptMode) && "NoPadding".equals(cryptPadding)) {
            return algorithm.concat("/CBC/NoPadding");
        }
        int al = algorithm.length();
        int cl = cryptMode.length() + al;
        char[] buffer = new char[cl + cryptPadding.length() + 2];
        algorithm.getChars(0, al, buffer, 0);
        buffer[al] = 47;
        cryptMode.getChars(0, cryptMode.length(), buffer, al + 1);
        buffer[cl + 1] = 47;
        cryptPadding.getChars(0, cryptPadding.length(), buffer, cl + 2);
        return new String(buffer);
    }

    public Cipher generateCipherInstance(String algorithmURI, String cryptMode, String cryptPadding) throws SignatureException, GeneralSecurityException {
        return this.getCipherFromPool(this.constructCipherRequest(algorithmURI, cryptMode, cryptPadding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cipher getCipherFromPool(String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm != null) {
            Hashtable hashtable = this.ciphers;
            synchronized (hashtable) {
                int i;
                Vector v = (Vector)this.ciphers.get(algorithm);
                int n = i = v != null ? v.size() : 0;
                if (i > 0) {
                    --this.cipherSize;
                    return (Cipher)v.remove(i - 1);
                }
            }
        }
        return Cipher.getInstance(algorithm, Configurator.getProviderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCipher(Cipher cipher) {
        if (cipher == null) {
            return;
        }
        String alg = cipher.getAlgorithm();
        Hashtable hashtable = this.ciphers;
        synchronized (hashtable) {
            if (this.cipherSize < this.MAX_SIZE) {
                Vector<Cipher> v = (Vector<Cipher>)this.ciphers.get(alg);
                if (v == null) {
                    v = new Vector<Cipher>(4);
                    this.ciphers.put(alg, v);
                }
                v.addElement(cipher);
                ++this.cipherSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDigest getMessageDigestFromPool(String algorithmURI) throws NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        String algorithm = Configurator.getDigestAlgorithm(algorithmURI);
        if (algorithm != null) {
            Hashtable hashtable = this.messageDigests;
            synchronized (hashtable) {
                int i;
                Vector v = (Vector)this.messageDigests.get(algorithm);
                int n = i = v != null ? v.size() : 0;
                if (i > 0) {
                    --this.messageSize;
                    return (MessageDigest)v.remove(i - 1);
                }
            }
        }
        return MessageDigest.getInstance(algorithm, Configurator.getProviderName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageDigest(MessageDigest messageDigest) {
        if (messageDigest == null) {
            return;
        }
        String alg = messageDigest.getAlgorithm();
        Hashtable hashtable = this.messageDigests;
        synchronized (hashtable) {
            if (this.messageSize < this.MAX_SIZE) {
                Vector<MessageDigest> v = (Vector<MessageDigest>)this.messageDigests.get(alg);
                if (v == null) {
                    v = new Vector<MessageDigest>(4);
                    this.messageDigests.put(alg, v);
                }
                v.addElement(messageDigest);
                ++this.messageSize;
            }
        }
    }
}

