/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import com.sap.engine.lib.xsl.xslt.NestedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class SignatureException
extends NestedException {
    private static final long serialVersionUID = 7251695308969444366L;
    public static boolean dumpFlag = Boolean.getBoolean("com.sap.xml.security.trace");
    public static boolean dumpPrivate = Boolean.getBoolean("com.sap.xml.security.trace.private");
    public static String PREFIX = "XML_SECURITY>> ";
    protected static StringBuffer additional = new StringBuffer();
    protected static StringBuffer dumpBuffer = new StringBuffer();

    public static void traceMessage(String message) {
        if (dumpFlag) {
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().println(message);
        }
    }

    public static void traceByte(String message, byte[] bytes) {
        if (dumpFlag) {
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().print(message);
            LogWriter.getSystemLogWriter().print(": ");
            LogWriter.getSystemLogWriter().println(new String(BASE64Encoder.encode(bytes)));
        }
    }

    public static void traceKey(String message, Key key) {
        if (dumpFlag) {
            if (key instanceof PrivateKey && !dumpPrivate) {
                return;
            }
            try {
                SignatureException.traceByte(message, key.getEncoded());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void traceCertificate(String message, Certificate cert) {
        if (dumpFlag) {
            try {
                SignatureException.traceByte(message, cert.getEncoded());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void traceCertificateArray(String message, Certificate[] certs) {
        if (dumpFlag) {
            try {
                int i = 0;
                while (i < certs.length) {
                    SignatureException.traceCertificate(String.valueOf(message) + i, certs[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void traceByteAsString(String message, byte[] bytes) {
        if (dumpFlag) {
            SignatureException.traceByte(message, new String(bytes));
        }
    }

    public static void traceNode(String message, Node domRepresentation) {
        if (dumpFlag) {
            try {
                Transformer tr = new TransformerFactoryImpl().newTransformer();
                tr.setOutputProperty("omit-xml-declaration", "yes");
                tr.setOutputProperty("indent", "no");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(bos);
                DOMSource source = new DOMSource(domRepresentation);
                tr.transform(source, result);
                String strRepr = new String(bos.toByteArray());
                SignatureException.traceByte(message, strRepr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void traceByte(String message, String bytes) {
        if (dumpFlag) {
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().print(message);
            LogWriter.getSystemLogWriter().print(": ");
            LogWriter.getSystemLogWriter().println(new String(BASE64Encoder.encode(bytes.getBytes())));
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().print(message);
            LogWriter.getSystemLogWriter().print(": ");
            LogWriter.getSystemLogWriter().println(bytes);
        }
    }

    protected static void throwing(String message, Throwable cause) {
        if (dumpFlag) {
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().println(message);
            LogWriter.getSystemLogWriter().print(PREFIX);
            cause.printStackTrace();
        }
    }

    protected static void errorT(String message) {
        if (dumpFlag) {
            LogWriter.getSystemLogWriter().print(PREFIX);
            LogWriter.getSystemLogWriter().print(Thread.currentThread().getName());
            LogWriter.getSystemLogWriter().print(" ");
            LogWriter.getSystemLogWriter().println(message);
        }
    }

    public SignatureException() {
        SignatureException.dump(null, null, null, this);
    }

    public SignatureException(Throwable cause) {
        super(cause);
        SignatureException.dump(null, cause, null, this);
    }

    public SignatureException(String message) {
        super(message);
        SignatureException.dump(message, null, null, this);
    }

    public SignatureException(String message, Object[] additionalData) {
        super(message);
        SignatureException.dump(message, null, additionalData, this);
    }

    public SignatureException(Throwable cause, String message) {
        super(cause, message);
        SignatureException.dump(message, cause, null, this);
    }

    public SignatureException(String message, Throwable cause) {
        super(message, cause);
        SignatureException.dump(message, cause, null, this);
    }

    public SignatureException(String message, Object[] additionalData, Throwable cause) {
        super(message, cause);
        SignatureException.dump(message, cause, additionalData, this);
    }

    public static synchronized void dump(String message, Throwable cause) {
        if (dumpFlag) {
            if (cause == null) {
                if (additional.length() > 0) {
                    SignatureException.errorT(additional.toString());
                }
                additional.setLength(0);
                return;
            }
            if (message == null) {
                message = cause.getMessage();
            }
            SignatureException.throwing(message, cause);
            if (additional.length() > 0) {
                SignatureException.errorT(additional.toString());
            }
            additional.setLength(0);
        }
    }

    public static synchronized void dump(String message, Throwable cause, Object[] additionalData, SignatureException parent) {
        if (dumpFlag) {
            if (cause == null) {
                cause = parent;
            }
            if (message == null) {
                message = cause.getMessage();
            }
            SignatureException.throwing(message, cause);
            if (additionalData != null) {
                int i = 0;
                while (i < additionalData.length) {
                    dumpBuffer.setLength(0);
                    SignatureException.dump(additionalData[i]);
                    additional.append("Argument(").append(i).append(")=").append(dumpBuffer).append('\n');
                    ++i;
                }
            }
            if (additional.length() > 0) {
                SignatureException.errorT(additional.toString());
            }
            additional.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(Object o) {
        if (o == null) {
            dumpBuffer.append("null");
            return;
        }
        dumpBuffer.append(o.getClass()).append(":");
        if (o instanceof String) {
            dumpBuffer.append('\"').append((String)o).append('\"');
        } else if (o instanceof byte[]) {
            dumpBuffer.append("byte[]");
            SignatureException.dumpByte((byte[])o);
        } else if (o instanceof ByteArrayInputStream) {
            ByteArrayInputStream bis = (ByteArrayInputStream)o;
            byte[] ret = null;
            ByteArrayInputStream byteArrayInputStream = bis;
            synchronized (byteArrayInputStream) {
                int available = bis.available();
                bis.reset();
                int available2 = bis.available();
                ret = new byte[available];
                try {
                    bis.read(ret);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                bis.reset();
                bis.skip(available2 -= available);
                dumpBuffer.append("stream[@").append(available2).append(']');
            }
            SignatureException.dumpByte(ret);
        } else if (o instanceof Node) {
            Node n = (Node)o;
            SignatureException.transform(n);
        } else if (o instanceof Key) {
            Key k = (Key)o;
            dumpBuffer.append("key[]");
            SignatureException.dumpByte(k.getEncoded());
        } else if (o instanceof Object[]) {
            dumpBuffer.append("{ ");
            Object[] ar = (Object[])o;
            if (ar != null && ar.length > 0) {
                int i = 0;
                while (i < ar.length - 1) {
                    SignatureException.dump(ar[i]);
                    dumpBuffer.append(", ");
                    ++i;
                }
                i = ar.length - 1;
                while (i < ar.length) {
                    SignatureException.dump(ar[i]);
                    ++i;
                }
            }
            dumpBuffer.append("}");
        } else if (o instanceof GenericElement) {
            Node n = ((GenericElement)o).getDomRepresentation();
            SignatureException.transform(n);
        } else if (o instanceof Certificate) {
            Certificate k = (Certificate)o;
            dumpBuffer.append("certificate[]");
            try {
                SignatureException.dumpByte(k.getEncoded());
            }
            catch (CertificateEncodingException e) {
                dumpBuffer.append("Unable to decode: ").append(e.getMessage());
            }
        } else if (o instanceof Transformation) {
            Transformation tr = (Transformation)o;
            dumpBuffer.append("URI=");
            SignatureException.dump(tr.uri);
            dumpBuffer.append(", additionalArgs=");
            SignatureException.dump(tr.additionalArgs);
            dumpBuffer.append(", hashmap=");
            SignatureException.dump(tr.dataHashmap);
        } else {
            dumpBuffer.append(o.toString());
        }
    }

    protected static void dumpByte(byte[] ar) {
        dumpBuffer.append("{ ");
        if (ar != null && ar.length > 0) {
            int i = 0;
            while (i < ar.length - 1) {
                dumpBuffer.append(ar[i]).append(", ");
                ++i;
            }
            if (ar.length > 0) {
                i = ar.length - 1;
                while (i < ar.length) {
                    dumpBuffer.append(ar[i]);
                    ++i;
                }
            }
        }
        dumpBuffer.append("}");
    }

    protected static void transform(Node n) {
        try {
            Transformer tr = new TransformerFactoryImpl().newTransformer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(n);
            tr.transform(source, result);
            dumpBuffer.append(new String(bos.toByteArray()));
        }
        catch (Throwable throwable) {}
    }
}

