/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.ByteKey;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.HashedKey;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class AbstractCustomCipher
extends Reusable
implements CustomCipher {
    public static final String BAD_PADDING_ATTACK_DETECTED = "Bad Padding Attack Detected";
    private static int MAX_ENTRIES = Integer.getInteger("com.sap.xml.security.cbcprotection.size", 100);
    protected Cipher internalCipher = null;
    protected Reusable messageDigest = null;
    protected HashedKey key;
    protected int operation = 0;
    static LinkedHashMap<HashedKey, Key> LRU_KEY_MAP = new LinkedHashMap<HashedKey, Key>(){
        private static final long serialVersionUID = -369024546415398087L;

        @Override
        public Key put(HashedKey key, Key value) {
            SignatureException.traceMessage("Putting bad key in cache:" + key);
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashedKey, Key> eldest) {
            return this.size() > AbstractCustomCipher.getMaxCacheEntries();
        }
    };
    static LinkedHashMap<ByteKey, ByteKey> LRU_DATA_MAP = new LinkedHashMap<ByteKey, ByteKey>(){
        private static final long serialVersionUID = 8444669246133635377L;

        @Override
        public ByteKey put(ByteKey key, ByteKey value) {
            SignatureException.traceByte("Putting bad data in cache:", key.getDigest());
            return super.put(key, value);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ByteKey, ByteKey> eldest) {
            return this.size() > AbstractCustomCipher.getMaxCacheEntries();
        }
    };

    @Override
    public int getOutputSize(int i1) throws IllegalStateException {
        return this.internalCipher.getOutputSize(i1);
    }

    @Override
    public void init(int mode, Key key) throws InvalidKeyException {
        this.checkKey(mode, key);
        try {
            this.internalCipher.init(mode, key);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public void init(int mode, Key key, AlgorithmParameterSpec algorithmparameterspec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkKey(mode, key);
        try {
            this.internalCipher.init(mode, key, algorithmparameterspec);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    private void checkKey(int mode, Key key) throws InvalidKeyException {
        this.operation = mode;
        if (mode == 2) {
            HashedKey hashedKey = new HashedKey(key);
            if (LRU_KEY_MAP.containsKey(hashedKey)) {
                SignatureException.traceMessage(BAD_PADDING_ATTACK_DETECTED);
                SignatureException.traceKey("Key found in cache", key);
                throw new InvalidKeyException(BAD_PADDING_ATTACK_DETECTED);
            }
            this.key = hashedKey;
            try {
                this.messageDigest = Reusable.getInstance("http://www.w3.org/2000/09/xmldsig#sha1");
            }
            catch (Exception e) {
                SignatureException.dump("Unable to init digest for bad padding attack", e);
            }
        }
    }

    protected ByteKey checkDataDigest() {
        if (2 == this.operation) {
            ByteKey byteKey;
            try {
                byte[] digest = this.getDigest().digest();
                byteKey = new ByteKey(digest);
                if (LRU_DATA_MAP.containsKey(byteKey)) {
                    SignatureException.traceMessage(BAD_PADDING_ATTACK_DETECTED);
                    SignatureException.traceByte("Data Hash found in cache", digest);
                    throw new IllegalStateException(BAD_PADDING_ATTACK_DETECTED);
                }
            }
            finally {
                this.messageDigest.release();
                this.messageDigest = null;
            }
            return byteKey;
        }
        return null;
    }

    protected MessageDigest getDigest() {
        return (MessageDigest)this.messageDigest.getInternal();
    }

    protected void handleBadPaddingException(ByteKey byteKey) {
        if (byteKey != null) {
            LRU_KEY_MAP.put(this.key, this.key.getInternalKey());
            LRU_DATA_MAP.put(byteKey, byteKey);
        }
    }

    @Override
    public byte[] update(byte[] abyte0, int i1, int j1) throws IllegalStateException {
        if (this.operation == 2) {
            this.getDigest().update(abyte0, i1, j1);
        }
        return this.internalCipher.update(abyte0, i1, j1);
    }

    @Override
    public int update(byte[] abyte0, int i1, int j1, byte[] abyte1, int k1) throws IllegalStateException, ShortBufferException {
        if (this.operation == 2) {
            this.getDigest().update(abyte0, i1, j1);
        }
        return this.internalCipher.update(abyte0, i1, j1, abyte1, k1);
    }

    @Override
    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        ByteKey byteKey = null;
        if (this.operation == 2) {
            byteKey = this.checkDataDigest();
        }
        try {
            return this.internalCipher.doFinal();
        }
        catch (BadPaddingException bpe) {
            this.handleBadPaddingException(byteKey);
            throw bpe;
        }
    }

    @Override
    public byte[] doFinal(byte[] abyte0, int i1, int j1) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        ByteKey byteKey = null;
        if (this.operation == 2) {
            this.getDigest().update(abyte0, i1, j1);
            byteKey = this.checkDataDigest();
        }
        try {
            return this.internalCipher.doFinal(abyte0, i1, j1);
        }
        catch (BadPaddingException bpe) {
            this.handleBadPaddingException(byteKey);
            throw bpe;
        }
    }

    @Override
    public int doFinal(byte[] abyte0, int i1, int j1, byte[] abyte1) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        ByteKey byteKey = null;
        if (this.operation == 2) {
            this.getDigest().update(abyte0, i1, j1);
            byteKey = this.checkDataDigest();
        }
        try {
            return this.internalCipher.doFinal(abyte0, i1, j1, abyte1);
        }
        catch (BadPaddingException bpe) {
            this.handleBadPaddingException(byteKey);
            throw bpe;
        }
    }

    @Override
    public int doFinal(byte[] abyte0, int i1, int j1, byte[] abyte1, int start) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        ByteKey byteKey = null;
        if (this.operation == 2) {
            this.getDigest().update(abyte0, i1, j1);
            byteKey = this.checkDataDigest();
        }
        try {
            return this.internalCipher.doFinal(abyte0, i1, j1, abyte1, start);
        }
        catch (BadPaddingException bpe) {
            this.handleBadPaddingException(byteKey);
            throw bpe;
        }
    }

    @Override
    public int doFinal(byte[] output, int offset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        ByteKey byteKey = null;
        if (this.operation == 2) {
            byteKey = this.checkDataDigest();
        }
        try {
            return this.internalCipher.doFinal(output, offset);
        }
        catch (BadPaddingException bpe) {
            this.handleBadPaddingException(byteKey);
            throw bpe;
        }
    }

    @Override
    public Object getInternal() {
        return this.internalCipher;
    }

    public static void setMaxCacheEntries(int mAX_ENTRIES) {
        LRU_DATA_MAP.clear();
        LRU_KEY_MAP.clear();
        MAX_ENTRIES = mAX_ENTRIES;
    }

    public static int getMaxCacheEntries() {
        return MAX_ENTRIES;
    }
}

