/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.util.Arrays;

public class ByteKey {
    private byte[] digest = null;

    public ByteKey(byte[] digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.digest = digest;
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteKey other = (ByteKey)obj;
        if (this.digest == null) {
            return other.digest == null;
        }
        return Arrays.equals(this.digest, other.digest);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String toString() {
        return new String(BASE64Encoder.encode(this.digest));
    }
}

