/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CustomCipherInputStream
extends FilterInputStream {
    public static final int BUFFER_SIZE = 512;
    private CustomCipher customCipher = null;
    private InputStream inputStream = null;
    private byte[] inputBuffer = new byte[512];
    private boolean endReached = false;
    private byte[] outputBuffer = null;
    private int index = 0;
    private int end = 0;

    private int decrypt() throws IOException {
        if (this.endReached) {
            return -1;
        }
        int i = this.inputStream.read(this.inputBuffer);
        if (i == -1) {
            this.endReached = true;
            try {
                this.end = this.customCipher.doFinal(this.outputBuffer, 0);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                this.outputBuffer = null;
            }
            catch (BadPaddingException badPaddingException) {
                this.outputBuffer = null;
            }
            catch (IllegalStateException illegalStateException) {
                this.outputBuffer = null;
            }
            catch (ShortBufferException shortBufferException) {
                this.outputBuffer = null;
            }
            if (this.outputBuffer == null) {
                return -1;
            }
            this.index = 0;
            SignatureException.traceByteAsString("Decrypted last portion of bytes", this.outputBuffer);
            return this.end;
        }
        try {
            this.end = this.customCipher.update(this.inputBuffer, 0, i, this.outputBuffer, 0);
        }
        catch (IllegalStateException illegalStateException) {
            this.outputBuffer = null;
        }
        catch (ShortBufferException shortBufferException) {
            this.outputBuffer = null;
        }
        this.index = 0;
        if (this.outputBuffer == null) {
            this.end = 0;
        } else {
            SignatureException.traceByteAsString("Decrypted portion of bytes", this.outputBuffer);
        }
        return this.end;
    }

    public CustomCipherInputStream(InputStream inputstream, CustomCipher cipher) {
        super(inputstream);
        this.inputStream = inputstream;
        this.customCipher = cipher;
        this.outputBuffer = new byte[512];
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.end) {
            int i = 0;
            while (i == 0) {
                i = this.decrypt();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.outputBuffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] abyte0) throws IOException {
        return this.read(abyte0, 0, abyte0.length);
    }

    @Override
    public int read(byte[] abyte0, int start, int length) throws IOException {
        if (this.index >= this.end) {
            int k = 0;
            while (k == 0) {
                k = this.decrypt();
            }
            if (k == -1) {
                return -1;
            }
        }
        if (length <= 0) {
            return 0;
        }
        int l = this.end - this.index;
        if (length < l) {
            l = length;
        }
        if (abyte0 != null) {
            System.arraycopy(this.outputBuffer, this.index, abyte0, start, l);
        }
        this.index += l;
        return l;
    }

    @Override
    public long skip(long l) throws IOException {
        int i = this.end - this.index;
        if (l > (long)i) {
            l = i;
        }
        if (l < 0L) {
            return 0L;
        }
        this.index += (int)l;
        return l;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.index;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        try {
            this.customCipher.doFinal();
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {}
        this.index = 0;
        this.end = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

