/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CustomCipherOutputStream
extends FilterOutputStream {
    public static final int BUFFER_SIZE = 512;
    private CustomCipher customCipher = null;
    private OutputStream outputStream = null;
    private byte[] inBuffer = null;
    private byte[] outBuffer = new byte[512];

    public CustomCipherOutputStream(OutputStream outputstream, CustomCipher cipher) {
        super(outputstream);
        this.inBuffer = new byte[1];
        this.outBuffer = new byte[512];
        this.outputStream = outputstream;
        this.customCipher = cipher;
    }

    @Override
    public void write(int i) throws IOException {
        this.inBuffer[0] = (byte)i;
        this.write(this.inBuffer, 0, 1);
    }

    @Override
    public void write(byte[] abyte0) throws IOException {
        this.write(abyte0, 0, abyte0.length);
    }

    @Override
    public void write(byte[] abyte0, int start, int length) throws IOException {
        while (length > 0) {
            int processed;
            int pro = Math.min(length, 512);
            while (this.customCipher.getOutputSize(pro) > 512) {
                --pro;
            }
            try {
                processed = this.customCipher.update(abyte0, start, pro, this.outBuffer, 0);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            this.outputStream.write(this.outBuffer, 0, processed);
            start += pro;
            length -= pro;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            int res = this.customCipher.doFinal(this.outBuffer, 0);
            this.outputStream.write(this.outBuffer, 0, res);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        this.flush();
        this.out.close();
    }
}

