/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import java.security.Key;
import java.util.Arrays;

public class HashedKey {
    private Key internalKey = null;

    public HashedKey(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.setInternalKey(key);
    }

    private void setInternalKey(Key internalKey) {
        this.internalKey = internalKey;
    }

    public Key getInternalKey() {
        return this.internalKey;
    }

    public int hashCode() {
        return this.internalKey.getAlgorithm().hashCode() ^ Arrays.hashCode(this.internalKey.getEncoded());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashedKey other = (HashedKey)obj;
        if (this.internalKey == null) {
            if (other.internalKey != null) {
                return false;
            }
        } else {
            if (!this.internalKey.getAlgorithm().equals(other.internalKey.getAlgorithm())) {
                return false;
            }
            if (!Arrays.equals(this.internalKey.getEncoded(), other.internalKey.getEncoded())) {
                return false;
            }
        }
        return true;
    }
}

