/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.xml.signature.crypto.ReusableConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public abstract class Reusable {
    public static final String LIMITED_CRYPTO_POLICY_MESSAGE = "This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).";
    public static Hashtable<String, Method> newInstanceUris = new Hashtable();
    public static Hashtable<String, Method> releaseMethods = new Hashtable();
    static final Object[] NO_ARGS = new Object[0];
    private String uri = null;

    static {
        ReusableConfigurator.readConfiguration();
    }

    public static Reusable getInstance(String uri) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method newInstance = newInstanceUris.get(uri);
        if (newInstance == null) {
            throw new IllegalArgumentException("No cipher for algorithm " + uri + " could be resolved");
        }
        Reusable ret = (Reusable)newInstance.invoke(null, NO_ARGS);
        ret.uri = uri;
        return ret;
    }

    public void release() {
        Method newInstance = releaseMethods.get(this.uri);
        try {
            newInstance.invoke((Object)this, NO_ARGS);
        }
        catch (Exception exception) {}
    }

    public String getUri() {
        return this.uri;
    }

    public abstract Object getInternal();
}

