/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableAESCipher;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableAESSecretKeyFactory;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableDESedeCipher;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableDESedeSecretKeyFactory;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableDSASignature;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableHMACSignature;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableHMACSignatureMD5;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableHMACSignatureSHA256;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableHMACSignatureSHA384;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableHMACSignatureSHA512;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableMD5Digest;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusablePool;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSA15Cipher;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSAOAEPCipher;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSASignature;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSASignatureMD5;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSASignatureSHA256;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSASignatureSHA384;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableRSASignatureSHA512;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableSHA1Digest;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableSHA256Digest;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableSHA512Digest;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusableSecureRandom;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReusableConfigurator {
    static Class[] EMPTY = new Class[0];
    static String provider = "IAIK";
    public static String defaultConfigFile = System.getProperty("com.sap.xml.security.algorithms", "algorithms.xml");

    public static void addClass(String className, String uri) throws Exception {
        Class<?> clas = Class.forName(className);
        Reusable.newInstanceUris.put(uri, clas.getMethod("newInstance", EMPTY));
        Reusable.releaseMethods.put(uri, clas.getMethod("release", EMPTY));
    }

    public static void readConfiguration() {
        try {
            Reusable.newInstanceUris.clear();
            Reusable.releaseMethods.clear();
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document doc = new File(defaultConfigFile).exists() ? builder.parse(new FileInputStream(defaultConfigFile)) : builder.parse(ReusableConfigurator.class.getResourceAsStream(defaultConfigFile));
            Element root = doc.getDocumentElement();
            provider = root.getAttribute("Provider");
            ReusablePool.MAX_SIZE = Integer.parseInt(root.getAttribute("MaxPoolSize"));
            NodeList algos = doc.getElementsByTagName("Algorithm");
            int i = 0;
            while (i < algos.getLength()) {
                Element algorithm = (Element)algos.item(i);
                ReusableConfigurator.addClass(algorithm.getAttribute("Class"), algorithm.getAttribute("Uri"));
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SignatureException.dump("Unable to load configuration", ex);
            ReusableConfigurator.initConstants();
        }
    }

    private static void initConstants() {
        try {
            ReusableConfigurator.addClass(ReusableAESCipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            ReusableConfigurator.addClass(ReusableAESCipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            ReusableConfigurator.addClass(ReusableAESCipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            ReusableConfigurator.addClass(ReusableAESSecretKeyFactory.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes128-cbc_gen");
            ReusableConfigurator.addClass(ReusableAESSecretKeyFactory.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes192-cbc_gen");
            ReusableConfigurator.addClass(ReusableAESSecretKeyFactory.class.getName(), "http://www.w3.org/2001/04/xmlenc#aes256-cbc_gen");
            ReusableConfigurator.addClass(ReusableDESedeCipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            ReusableConfigurator.addClass(ReusableDESedeSecretKeyFactory.class.getName(), "http://www.w3.org/2001/04/xmlenc#tripledes-cbc_gen");
            ReusableConfigurator.addClass(ReusableDSASignature.class.getName(), "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
            ReusableConfigurator.addClass(ReusableHMACSignature.class.getName(), "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            ReusableConfigurator.addClass(ReusableRSASignature.class.getName(), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            ReusableConfigurator.addClass(ReusableSecureRandom.class.getName(), "http://www.acme.com/secran#sha1-prng");
            ReusableConfigurator.addClass(ReusableRSAOAEPCipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            ReusableConfigurator.addClass(ReusableRSA15Cipher.class.getName(), "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            ReusableConfigurator.addClass(ReusableMD5Digest.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#md5");
            ReusableConfigurator.addClass(ReusableSHA1Digest.class.getName(), "http://www.w3.org/2000/09/xmldsig#sha1");
            ReusableConfigurator.addClass(ReusableSHA256Digest.class.getName(), "http://www.w3.org/2001/04/xmlenc#sha256");
            ReusableConfigurator.addClass(ReusableSHA512Digest.class.getName(), "http://www.w3.org/2001/04/xmlenc#sha512");
            ReusableConfigurator.addClass(ReusableRSASignatureMD5.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
            ReusableConfigurator.addClass(ReusableRSASignatureSHA256.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            ReusableConfigurator.addClass(ReusableRSASignatureSHA384.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
            ReusableConfigurator.addClass(ReusableRSASignatureSHA512.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
            ReusableConfigurator.addClass(ReusableHMACSignatureMD5.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#hmac-md5");
            ReusableConfigurator.addClass(ReusableHMACSignatureSHA256.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
            ReusableConfigurator.addClass(ReusableHMACSignatureSHA384.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384");
            ReusableConfigurator.addClass(ReusableHMACSignatureSHA512.class.getName(), "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        }
        catch (Exception ex) {
            SignatureException.dump("Unable to load configuration", ex);
        }
    }

    public static String getProvider() {
        return provider;
    }

    public static String getDefaultConfigFile() {
        return defaultConfigFile;
    }

    public static void setDefaultConfigFile(String defaultConfigFile) {
        ReusableConfigurator.defaultConfigFile = defaultConfigFile;
        ReusableConfigurator.readConfiguration();
    }
}

