/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto.impl;

import com.sap.engine.lib.xml.signature.crypto.CustomSignature;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusablePool;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.Arrays;
import javax.crypto.Mac;

public class ReusableHMACSignatureSHA256
extends Reusable
implements CustomSignature {
    public static final String HMAC_SHA256_URI = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    public static ReusablePool pool = new ReusablePool(ReusablePool.MAX_SIZE);
    protected Mac internalMac = Mac.getInstance("HmacSHA256");

    private ReusableHMACSignatureSHA256() throws NoSuchAlgorithmException, NoSuchProviderException {
    }

    @Override
    public void update(byte[] bytes) throws SignatureException {
        this.internalMac.update(bytes);
    }

    @Override
    public void initSign(Key signKey) throws SignatureException, InvalidKeyException {
        try {
            this.internalMac.init(signKey);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public void initVerify(Key verifyKey) throws SignatureException, InvalidKeyException {
        try {
            this.internalMac.init(verifyKey);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public byte[] sign() throws SignatureException {
        return this.internalMac.doFinal();
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        byte[] res = this.sign();
        return Arrays.equals(res, signature);
    }

    public static Reusable newInstance() throws Exception {
        Reusable ret = pool.newInstance();
        if (ret == null) {
            ret = new ReusableHMACSignatureSHA256();
        }
        return ret;
    }

    @Override
    public void release() {
        pool.release(this);
    }

    @Override
    public Object getInternal() {
        return this.internalMac;
    }
}

