/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto.impl;

import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusablePool;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class ReusableRSAOAEPCipher
extends Reusable
implements CustomCipher {
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static ReusablePool pool = new ReusablePool(ReusablePool.MAX_SIZE);
    protected Cipher internalCipher = Cipher.getInstance("RSA/ECB/NoPadding");

    private ReusableRSAOAEPCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
    }

    @Override
    public int getOutputSize(int i1) throws IllegalStateException {
        return this.internalCipher.getOutputSize(i1);
    }

    @Override
    public void init(int i1, Key key) throws InvalidKeyException {
        try {
            this.internalCipher.init(i1, key);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public void init(int i1, Key key, AlgorithmParameterSpec algorithmparameterspec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.internalCipher.init(i1, key, algorithmparameterspec);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public byte[] update(byte[] abyte0, int i1, int j1) throws IllegalStateException {
        return this.internalCipher.update(abyte0, i1, j1);
    }

    @Override
    public int update(byte[] abyte0, int i1, int j1, byte[] abyte1, int k1) throws IllegalStateException, ShortBufferException {
        return this.internalCipher.update(abyte0, i1, j1, abyte1, k1);
    }

    @Override
    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.internalCipher.doFinal();
    }

    @Override
    public byte[] doFinal(byte[] abyte0, int i1, int j1) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.internalCipher.doFinal(abyte0, i1, j1);
    }

    @Override
    public int doFinal(byte[] abyte0, int i1, int j1, byte[] abyte1) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.internalCipher.doFinal(abyte0, i1, j1, abyte1);
    }

    @Override
    public int doFinal(byte[] abyte0, int i1, int j1, byte[] abyte1, int start) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.internalCipher.doFinal(abyte0, i1, j1, abyte1, start);
    }

    public static Reusable newInstance() throws Exception {
        Reusable ret = pool.newInstance();
        if (ret == null) {
            ret = new ReusableRSAOAEPCipher();
        }
        return ret;
    }

    @Override
    public void release() {
        pool.release(this);
    }

    @Override
    public int getIVLength() {
        return 0;
    }

    @Override
    public Object getInternal() {
        return this.internalCipher;
    }

    @Override
    public int doFinal(byte[] output, int offset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return this.internalCipher.doFinal(output, offset);
    }
}

