/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto.impl;

import com.sap.engine.lib.xml.signature.crypto.CustomSignature;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusablePool;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class ReusableRSASignature
extends Reusable
implements CustomSignature {
    public static final String RSA_SHA1_URI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static ReusablePool pool = new ReusablePool(ReusablePool.MAX_SIZE);
    protected Signature internalSignature = Signature.getInstance("SHA1withRSA");

    private ReusableRSASignature() throws NoSuchAlgorithmException, NoSuchProviderException {
    }

    @Override
    public void update(byte[] bytes) throws SignatureException {
        this.internalSignature.update(bytes);
    }

    @Override
    public void initSign(Key signKey) throws SignatureException, InvalidKeyException {
        try {
            this.internalSignature.initSign((PrivateKey)signKey);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public void initVerify(Key verifyKey) throws SignatureException, InvalidKeyException {
        try {
            this.internalSignature.initVerify((PublicKey)verifyKey);
        }
        catch (InvalidKeyException ike) {
            throw new InvalidKeyException("This key is not allowed due to the crypto policy file in use. Using Unlimited Strength Jurisdiction Policy Files will fix the problem (Note: 989517).", ike);
        }
    }

    @Override
    public byte[] sign() throws SignatureException {
        return this.internalSignature.sign();
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        return this.internalSignature.verify(signature);
    }

    public static Reusable newInstance() throws Exception {
        Reusable ret = pool.newInstance();
        if (ret == null) {
            ret = new ReusableRSASignature();
        }
        return ret;
    }

    @Override
    public void release() {
        pool.release(this);
    }

    @Override
    public Object getInternal() {
        return this.internalSignature;
    }
}

