/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.crypto.impl;

import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.crypto.impl.ReusablePool;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public class ReusableSecureRandom
extends Reusable {
    public static final String SHA1_PRNG_URI = "http://www.acme.com/secran#sha1-prng";
    public static ReusablePool pool = new ReusablePool(ReusablePool.MAX_SIZE);
    protected SecureRandom internalRandom = SecureRandom.getInstance("SHA1PRNG");

    private ReusableSecureRandom() throws NoSuchAlgorithmException, NoSuchProviderException {
    }

    @Override
    public Object getInternal() {
        return this.internalRandom;
    }

    public static Reusable newInstance() throws Exception {
        Reusable ret = pool.newInstance();
        if (ret == null) {
            ret = new ReusableSecureRandom();
        }
        return ret;
    }

    @Override
    public void release() {
        pool.release(this);
    }
}

