/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CipherData
extends GenericElement {
    private String cipherValue = null;
    protected static final String localName = "CipherData";
    private byte[] value = null;
    private int len = 0;
    boolean isEncoded = true;

    public CipherData(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(parent.getOwner(), namespaceUri, qualifiedName, parent);
    }

    public CipherData(GenericElement parent) throws SignatureException {
        super("http://www.w3.org/2001/04/xmlenc#", "xenc:".concat(localName), parent);
    }

    public CipherData(Element domRepr, GenericElement parent) throws SignatureException {
        super(domRepr, parent);
    }

    public void setCipherValue(String cipherValue) {
        this.cipherValue = cipherValue;
    }

    public void setReference(String reference, Transformation[] transforms) {
        if (transforms == null) {
            transforms = new Transformation[]{};
        }
    }

    public void construct() throws SignatureException {
        if (this.cipherValue != null) {
            GenericElement cVal = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:".concat("CipherValue"), this);
            cVal.appendTextChild(this.cipherValue);
        } else if (this.value != null) {
            GenericElement cVal = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:".concat("CipherValue"), this);
            cVal.appendBinaryTextChild(this.value);
        }
    }

    int getLen() {
        return this.len;
    }

    byte[] getCipherValue() throws SignatureException {
        if (this.value != null) {
            if (this.isEncoded) {
                this.base64Decode(this.value);
                this.isEncoded = false;
            }
            return this.value;
        }
        if (this.cipherValue != null) {
            this.value = BASE64Decoder.decode(this.cipherValue.getBytes());
            this.len = this.value.length;
            this.isEncoded = false;
            return this.value;
        }
        NodeList n = this.domRepresentation.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        if (n != null && n.getLength() != 0) {
            Element vEl = (Element)n.item(0);
            this.value = XMLCryptor.gatherBytes(vEl);
            this.base64Decode(this.value);
        } else {
            CipherReference cr = (CipherReference)this.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
            this.value = cr.getReferenced();
            this.len = this.value.length;
        }
        this.isEncoded = false;
        return this.value;
    }

    void base64Decode(byte[] v) throws SignatureException {
        try {
            int temp;
            if (v.length == 0) {
                this.len = 0;
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(v);
            BASE64Decoder dec = new BASE64Decoder(is);
            this.len = 0;
            while ((temp = dec.read(v, this.len, v.length)) != -1) {
                this.len += temp;
            }
            dec.close();
        }
        catch (IOException ex) {
            throw new SignatureException(ex);
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] bs) {
        this.isEncoded = true;
        this.value = bs;
    }
}

