/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Constants
extends com.sap.engine.lib.xml.signature.Constants {
    public static final Hashtable cipherAlgMappings = new Hashtable();
    public static final Hashtable ivLengths;

    static {
        cipherAlgMappings.put("DESede", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        cipherAlgMappings.put("3DES", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        cipherAlgMappings.put("Rijndael", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        cipherAlgMappings.put("Rijndael-256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        cipherAlgMappings.put("RSA", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        cipherAlgMappings.put("RSA", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        ivLengths = new Hashtable();
        ivLengths.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Integer("8"));
        ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Integer("16"));
        ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new Integer("32"));
    }

    public static final void addCipherAlgorithm(String jceIdentifier, String uri) {
        cipherAlgMappings.put(jceIdentifier, uri);
    }

    public static final Hashtable getAllRegisteredCipherAlgorithms() {
        return cipherAlgMappings;
    }

    public static final String getCipherJCEFromURI(String uri) {
        Enumeration en = cipherAlgMappings.keys();
        while (en.hasMoreElements()) {
            String nextJCE = (String)en.nextElement();
            String nextURI = (String)cipherAlgMappings.get(nextJCE);
            if (nextURI == null || !nextURI.equals(uri)) continue;
            return nextJCE;
        }
        return null;
    }

    public static final String getCipherURIFromJCE(String jceCipher) {
        return (String)cipherAlgMappings.get(jceCipher);
    }
}

