/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.EncryptedType;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptedData
extends EncryptedType {
    public static final String localName = "EncryptedData";
    private boolean replaced = false;

    public EncryptedData(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public EncryptedData(Node parent) throws SignatureException {
        super(parent, localName);
    }

    public EncryptedData(Node parent, int childIndex) throws SignatureException {
        super(parent, localName, childIndex);
    }

    public EncryptedData(Element n, boolean unused) throws SignatureException {
        super(n, unused);
    }

    public void replaceContent() throws SignatureException {
        if (this.replaced) {
            return;
        }
        byte[] decryptedOctets = this.getDecrypted();
        try {
            Node domParent = this.getDomRepresentation().getParentNode();
            String encryptionType = ((Element)this.getDomRepresentation()).getAttribute("Type");
            Node toAdd = null;
            Hashtable mappings = DOM.getNamespaceMappingsInScope(domParent);
            if (encryptionType == null || encryptionType.length() == 0 || encryptionType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                byte[] temp1 = new byte[decryptedOctets.length + 7];
                temp1[0] = 60;
                temp1[1] = 97;
                temp1[2] = 62;
                System.arraycopy(decryptedOctets, 0, temp1, 3, decryptedOctets.length);
                int index = temp1.length - 4;
                temp1[index++] = 60;
                temp1[index++] = 47;
                temp1[index++] = 97;
                temp1[index++] = 62;
                Element d = SignatureContext.parse(new ByteArrayInputStream(temp1), mappings).getDocumentElement();
                Document doc = this.getDomRepresentation().getOwnerDocument();
                DocumentFragment fr = doc.createDocumentFragment();
                NodeList nl = d.getChildNodes();
                int len = nl.getLength();
                int i = 0;
                while (i < len) {
                    fr.appendChild(doc.importNode(nl.item(i).cloneNode(true), true));
                    ++i;
                }
                toAdd = fr;
            } else if (encryptionType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Document temp = SignatureContext.parse(new ByteArrayInputStream(decryptedOctets), mappings);
                toAdd = temp.getDocumentElement();
            }
            toAdd = domParent instanceof Document ? ((Document)domParent).importNode(toAdd, true) : domParent.getOwnerDocument().importNode(toAdd, true);
            Node sibling = this.getDomRepresentation().getNextSibling();
            domParent.removeChild(this.getDomRepresentation());
            if (sibling != null) {
                domParent.insertBefore(toAdd, sibling);
            } else {
                domParent.appendChild(toAdd);
            }
            this.replaced = true;
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }
}

