/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.EncryptedType;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedKey
extends EncryptedType {
    private String carriedKeyName = null;
    private String recipient = null;
    protected Key wrappedKey = null;

    public EncryptedKey() throws SignatureException {
        super((Node)null, "EncryptedKey");
        this.type = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    }

    public EncryptedKey(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
        this.type = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    }

    public EncryptedKey(Node parent) throws SignatureException {
        super(parent, "EncryptedKey");
        this.type = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    }

    public EncryptedKey(Element n, boolean unused) throws SignatureException {
        super(n, unused);
        this.type = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    }

    public EncryptedKey(Element n, GenericElement parent) throws SignatureException {
        super(n, parent);
    }

    public void setCarriedKeyName(String carriedKeyName) throws SignatureException {
        this.carriedKeyName = carriedKeyName;
        GenericElement name = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:carriedKeyName", this);
        name.appendTextChild(carriedKeyName);
    }

    public String getCarriedKey() {
        return this.carriedKeyName;
    }

    public void setRecipient(String recipient) throws SignatureException {
        this.recipient = recipient;
        GenericElement name = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:recipient", this);
        name.appendTextChild(recipient);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public Transformation[] getReferences(Transformation[] $references) {
        return $references;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Key getWrappedKey() throws SignatureException {
        if (this.wrappedKey == null) {
            byte[] dec = this.getWrappedKeyEncoded();
            GenericElement el = this.getParent();
            while (el != null && !(el instanceof EncryptedType)) {
                el = el.getParent();
            }
            String uri = this.type;
            if (el != null) {
                EncryptedType et = (EncryptedType)el;
                uri = et.getEncryptionMethod().getAlgorithmURI();
            }
            this.wrappedKey = this.buildKey(dec, uri);
        }
        return this.wrappedKey;
    }

    protected Key buildKey(byte[] dec, String uri) throws SignatureException {
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(uri.concat("_gen"));
            SecretKeyFactory keyFactory = (SecretKeyFactory)reusable.getInternal();
            String algorithm = Configurator.getCipherAlgorithm(uri);
            SecretKeySpec spec = new SecretKeySpec(dec, algorithm);
            this.wrappedKey = keyFactory.generateSecret(spec);
            SecretKey secretKey = this.wrappedKey;
            return secretKey;
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to init key", new Object[]{dec, uri}, ex);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    public byte[] getWrappedKeyEncoded() throws SignatureException {
        byte[] value;
        KeyTransporter tr = KeyTransporter.getInstance(this.getEncryptionMethod().getAlgorithmURI(), this);
        CipherData cd = this.getCipherData();
        byte[] tv = cd.getCipherValue();
        int len = cd.getLen();
        if (len == tv.length) {
            value = tv;
        } else {
            value = new byte[len];
            System.arraycopy(tv, 0, value, 0, len);
        }
        return tr.decrypt(this.getKey(), value);
    }
}

