/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EncryptedType
extends GenericElement {
    protected String type = "http://www.w3.org/2001/04/xmlenc#Element";
    protected byte[] decrypted = null;
    protected Key key = null;

    public EncryptedType(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(parent.getOwner(), namespaceUri, qualifiedName, parent);
    }

    public EncryptedType(Node parent, String localName, int childIndex) throws SignatureException {
        super(EncryptedType.getOwner(parent), "http://www.w3.org/2001/04/xmlenc#", "xenc:".concat(localName), null);
        if (parent != null) {
            EncryptedType.insertAtPosition(parent, this.domRepresentation, childIndex);
        } else {
            EncryptedType.insertAtPosition(this.getOwner(), this.domRepresentation, childIndex);
        }
    }

    public EncryptedType(Element domRepr, GenericElement parent) throws SignatureException {
        super(domRepr, parent);
    }

    private static Document getOwner(Node parent) {
        return parent != null ? (Document)(parent instanceof Document ? parent : parent.getOwnerDocument()) : new DocumentImpl();
    }

    public EncryptedType(Node parent, String localName) throws SignatureException {
        this(parent, localName, -1);
    }

    public EncryptedType(Element n, boolean unused) throws SignatureException {
        super(n, null);
    }

    public CipherData getCipherData() throws SignatureException {
        return (CipherData)this.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherData");
    }

    public EncryptionMethod getEncryptionMethod() throws SignatureException {
        return (EncryptionMethod)this.getDescendant("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
    }

    public KeyInfo getKeyInfo() throws SignatureException {
        return (KeyInfo)this.getDescendant("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    }

    public void setType(String type) {
        this.type = type;
    }

    public void construct() {
        if (this.type != null) {
            this.setAttribute("Type", this.type);
        }
    }

    public void construct(int $childIndex) {
        this.setAttribute("Type", this.type);
    }

    protected static void insertAtPosition(Node parent, Node child, int position) throws SignatureException {
        NodeList childNodes = parent.getChildNodes();
        if (position > childNodes.getLength()) {
            throw new SignatureException("Cannot insert child on position" + position + " when old childs are only " + childNodes.getLength() + ".", new Object[]{parent, child});
        }
        if (position < 0 || position == childNodes.getLength()) {
            parent.appendChild(child);
            return;
        }
        if (position == 0) {
            if (childNodes.getLength() <= 0) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, childNodes.item(0));
            }
            return;
        }
        Node next = parent.getFirstChild();
        int i = 0;
        while (i < position) {
            next = next.getNextSibling();
            ++i;
        }
        parent.insertBefore(child, next);
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public Key getKey() throws SignatureException {
        if (this.key == null) {
            this.key = this.getKeyInfo().getKey();
        }
        return this.key;
    }

    public byte[] getDecrypted() throws SignatureException {
        if (this.decrypted == null) {
            Reusable reusable = null;
            try {
                try {
                    CipherData data = this.getCipherData();
                    String algorithmURI = this.getEncryptionMethod().getAlgorithmURI();
                    reusable = Reusable.getInstance(algorithmURI);
                    CustomCipher cipher = (CustomCipher)((Object)reusable);
                    byte[] encoded = data.getCipherValue();
                    byte[] IV = new byte[Configurator.getIVLength(algorithmURI)];
                    System.arraycopy(encoded, 0, IV, 0, IV.length);
                    IvParameterSpec pSpec = new IvParameterSpec(IV);
                    Key k = this.getKey();
                    if (k == null) {
                        throw new SignatureException("No encryption key found", new Object[]{this.domRepresentation});
                    }
                    cipher.init(2, k, pSpec);
                    this.decrypted = cipher.doFinal(encoded, IV.length, data.getLen() - IV.length);
                }
                catch (SignatureException sig) {
                    throw sig;
                }
                catch (Exception ex) {
                    throw new SignatureException("Unable to decrypt", ex);
                }
            }
            finally {
                if (reusable != null) {
                    reusable.release();
                }
            }
        }
        return this.decrypted;
    }
}

