/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import java.math.BigInteger;
import org.w3c.dom.Element;

public class EncryptionMethod
extends GenericElement {
    public String algorithmURI = null;
    public BigInteger size = null;

    public EncryptionMethod(GenericElement parent) throws SignatureException {
        super("http://www.w3.org/2001/04/xmlenc#", "xenc:".concat("EncryptionMethod"), parent);
    }

    public EncryptionMethod(String algorithmURI, BigInteger size, GenericElement parent) throws SignatureException {
        super("http://www.w3.org/2001/04/xmlenc#", "xenc:".concat("EncryptionMethod"), parent);
        this.algorithmURI = algorithmURI;
        this.size = size;
    }

    public EncryptionMethod(Element domRepr, GenericElement parent) throws SignatureException {
        super(domRepr, parent);
    }

    public void setAlgorithmURI(String algorithmURI) {
        this.algorithmURI = algorithmURI;
    }

    public String getAlgorithmURI() throws SignatureException {
        if (this.algorithmURI == null) {
            this.algorithmURI = this.domRepresentation.getAttribute("Algorithm");
            if (this.algorithmURI == null) {
                throw new SignatureException("Algorithm attribute is required", new Object[]{this.domRepresentation});
            }
        }
        return this.algorithmURI;
    }

    public BigInteger getKeySize() throws SignatureException {
        if (this.size == null) {
            String sizeRepr = this.domRepresentation.getAttribute("Algorithm");
            try {
                if (sizeRepr != null) {
                    this.size = new BigInteger(sizeRepr);
                }
            }
            catch (Exception ex) {
                throw new SignatureException("Unable to parse key size", new Object[]{this.domRepresentation}, ex);
            }
        }
        return this.size;
    }

    public void construct() throws SignatureException {
        this.setAttribute("Algorithm", this.algorithmURI);
        if (this.size != null) {
            GenericElement keySize = new GenericElement(null, "KeySize", this);
            keySize.appendTextChild(this.size.toString());
        }
    }
}

