/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLCryptor {
    public TransformationFactory trFact = TransformationFactory.newInstance();
    protected Key key = null;
    protected String algorithmURI = null;
    protected byte[] IV = null;
    protected AlgorithmParameters algParams = null;
    protected String primaryEncodingFormat = "ASN.1";
    protected String prngIdentifier = "SHA1PRNG";
    protected byte[] randomSeed = null;
    protected int ivLength = -1;
    protected byte[] toEncrypt;
    static CharArray temp = new CharArray(1000, 1000);

    public AlgorithmParameters getAlgorithmParameters() {
        return this.algParams;
    }

    public void specifyRandomness(String identifier, byte[] seed) {
        this.prngIdentifier = identifier;
        this.randomSeed = seed;
    }

    public void setAlgorithmParameters(AlgorithmParameters algParams) {
        this.algParams = algParams;
    }

    public byte[] getIV() {
        return this.IV;
    }

    public void setIV(byte[] IV) {
        this.IV = IV;
    }

    public void setKey(Key key) {
        this.key = key;
        try {
            this.algorithmURI = Configurator.getCipherURIFromJCE(key.getAlgorithm());
        }
        catch (SignatureException signatureException) {}
    }

    public void setEncryptionKey(Key key) throws SignatureException {
        this.key = key;
        this.algorithmURI = Configurator.getCipherURIFromJCE(key.getAlgorithm());
    }

    public void setIVLength(int ivLength) {
        this.ivLength = ivLength;
    }

    protected String decrypt0(byte[] content) throws IOException, GeneralSecurityException, SignatureException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] encryptedWithIV = BASE64Decoder.decode(content);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.algorithmURI);
            CustomCipher ciph = (CustomCipher)((Object)reusable);
            int start = ciph.getIVLength();
            this.IV = new byte[start];
            System.arraycopy(encryptedWithIV, 0, this.IV, 0, start);
            IvParameterSpec spec = new IvParameterSpec(this.IV);
            ciph.init(2, this.key, spec);
            String string = new String(ciph.doFinal(encryptedWithIV, start, encryptedWithIV.length - start));
            return string;
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    protected byte[] decrypt1(byte[] content) throws IOException, GeneralSecurityException, SignatureException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        byte[] encryptedWithIV = BASE64Decoder.decode(content);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.algorithmURI);
            CustomCipher ciph = (CustomCipher)((Object)reusable);
            int start = ciph.getIVLength();
            this.IV = new byte[start];
            System.arraycopy(encryptedWithIV, 0, this.IV, 0, start);
            IvParameterSpec spec = new IvParameterSpec(this.IV);
            ciph.init(2, this.key, spec);
            byte[] byArray = ciph.doFinal(encryptedWithIV, start, encryptedWithIV.length - start);
            return byArray;
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    protected void encrypt0() throws GeneralSecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.algorithmURI);
            CustomCipher ciph = (CustomCipher)((Object)reusable);
            this.IV = new byte[ciph.getIVLength()];
            this.randomize(this.IV);
            IvParameterSpec spec = new IvParameterSpec(this.IV);
            ciph.init(1, this.key, spec);
            byte[] total = new byte[this.IV.length + ciph.getOutputSize(this.toEncrypt.length)];
            System.arraycopy(this.IV, 0, total, 0, this.IV.length);
            ciph.doFinal(this.toEncrypt, 0, this.toEncrypt.length, total, this.IV.length);
            this.toEncrypt = total;
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    protected byte[] encrypt0(byte[] toEncrypt) throws GeneralSecurityException, SignatureException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.algorithmURI);
            CustomCipher ciph = (CustomCipher)((Object)reusable);
            this.IV = new byte[ciph.getIVLength()];
            this.randomize(this.IV);
            IvParameterSpec spec = new IvParameterSpec(this.IV);
            ciph.init(1, this.key, spec);
            byte[] total = new byte[this.IV.length + ciph.getOutputSize(toEncrypt.length)];
            System.arraycopy(this.IV, 0, total, 0, this.IV.length);
            ciph.doFinal(toEncrypt, 0, toEncrypt.length, total, this.IV.length);
            byte[] byArray = total;
            return byArray;
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    protected byte[] encrypt0(Element el, boolean contentOnly) throws SignatureException, IllegalArgumentException, GeneralSecurityException, IllegalAccessException, InvocationTargetException {
        if (el instanceof BinaryTextImpl) {
            this.toEncrypt = ((BinaryTextImpl)((Object)el)).getBinaryData();
            ((BinaryTextImpl)((Object)el)).setBinaryData(null);
        } else if (contentOnly) {
            NodeList children = el.getChildNodes();
            int ln = children.getLength();
            if (ln == 1 && children.item(0) instanceof BinaryTextImpl) {
                this.toEncrypt = ((BinaryTextImpl)children.item(0)).getBinaryData();
                ((BinaryTextImpl)children.item(0)).setBinaryData(null);
            } else {
                DocumentFragment df = el.getOwnerDocument().createDocumentFragment();
                int i = 0;
                while (i < ln) {
                    df.appendChild(children.item(i).cloneNode(true));
                    ++i;
                }
                this.toEncrypt = Canonicalization.canonicalize(df, true);
            }
        } else {
            this.toEncrypt = Canonicalization.canonicalize(el, true);
        }
        this.encrypt0();
        byte[] temp = this.toEncrypt;
        this.toEncrypt = null;
        return temp;
    }

    protected static byte[] append(byte[] arg1, byte[] arg2) {
        int resLength = arg1.length + arg2.length;
        byte[] result = new byte[resLength];
        System.arraycopy(arg1, 0, result, 0, arg1.length);
        System.arraycopy(arg2, 0, result, arg1.length, arg2.length);
        return result;
    }

    protected int getEncryptedNoIV(byte[] encryptedWithIV) throws SignatureException {
        int cfr_ignored_0 = encryptedWithIV.length;
        this.ivLength = this.getLength();
        this.IV = new byte[this.ivLength];
        System.arraycopy(encryptedWithIV, 0, this.IV, 0, this.ivLength);
        return this.ivLength;
    }

    protected int getLength() throws SignatureException {
        if (this.ivLength > 0) {
            return this.ivLength;
        }
        return Configurator.getIVLength(this.algorithmURI);
    }

    public static synchronized String gatherText(Node n) {
        temp.clear();
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node next = nl.item(i);
            if (next.getNodeType() == 3) {
                temp.append(next.getNodeValue());
            }
            ++i;
        }
        return temp.toString();
    }

    public static byte[] gatherBytes(Node n) {
        try {
            NodeList nl = n.getChildNodes();
            ByteArrayOutputStream out = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            int len = nl.getLength();
            if (len > 0) {
                Node nn = nl.item(0);
                if (nn instanceof BinaryTextImpl) {
                    if (len == 1) {
                        return ((BinaryTextImpl)nn).getBinaryData();
                    }
                    out.write(((BinaryTextImpl)nn).getBinaryData());
                } else if (nn.getNodeType() == 3 || nn.getNodeType() == 4) {
                    if (len == 1) {
                        return nn.getNodeValue().getBytes();
                    }
                    out.write(nn.getNodeValue().getBytes());
                }
            } else {
                return new byte[0];
            }
            int i = 1;
            while (i < len) {
                Node next = nl.item(i);
                if (next instanceof BinaryTextImpl) {
                    out.write(((BinaryTextImpl)next).getBinaryData());
                } else if (next.getNodeType() == 3 || next.getNodeType() == 4) {
                    out.write(next.getNodeValue().getBytes());
                }
                ++i;
            }
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static void deleteContent(Element e) {
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node next = nl.item(i);
            if (next.getNodeType() == 3) {
                e.removeChild(next);
            }
            ++i;
        }
    }

    protected String getAlgOnly(String algWithModePad) {
        return algWithModePad.substring(0, algWithModePad.indexOf("/"));
    }

    protected void randomize(byte[] input) throws GeneralSecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance("http://www.acme.com/secran#sha1-prng");
            SecureRandom rand = (SecureRandom)reusable.getInternal();
            if (this.randomSeed != null) {
                rand.setSeed(this.randomSeed);
            }
            rand.nextBytes(input);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    public static int decryptBuffer(Cipher cipher, byte[] encoded, int start, int length, byte[] decoded, int offset, int max_size) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int read;
        int toRead = max_size < length ? max_size : length;
        do {
            read = cipher.update(encoded, start, toRead, decoded, offset);
            start += toRead;
            offset += read;
        } while ((toRead = max_size < (length -= toRead) ? max_size : length) > 0);
        read = cipher.doFinal(decoded, offset);
        return offset += read;
    }
}

