/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDecryptor
extends XMLCryptor {
    protected boolean parseDecrypted = true;

    public boolean isParseDecrypted() {
        return this.parseDecrypted;
    }

    public void setParseDecrypted(boolean parseDecrypted) {
        this.parseDecrypted = parseDecrypted;
    }

    private static String deduceAlgorithm(EncryptedData encData) throws SignatureException {
        EncryptionMethod encMethod = encData.getEncryptionMethod();
        if (encMethod == null || encMethod.getAttribute("Algorithm", null, null) == null) {
            return null;
        }
        return encMethod.getAttribute("Algorithm", null, null);
    }

    public String decryptEncData(Element el) throws SignatureException {
        return this.decryptEncData(el, null);
    }

    public byte[] decryptToOctets(Element el, String $algorithmURI) throws SignatureException {
        EncryptedData encData = new EncryptedData(el, true);
        encData.initializeDescendants();
        if (this.key != null) {
            encData.setKey(this.key);
        }
        try {
            byte[] ret = encData.getDecrypted();
            if (ret != null) {
                return ret;
            }
        }
        catch (Exception exception) {}
        if ($algorithmURI == null) {
            $algorithmURI = XMLDecryptor.deduceAlgorithm(encData);
        }
        if ($algorithmURI == null) {
            throw new SignatureException("Unable to determine algorithm.", new Object[]{el, $algorithmURI});
        }
        this.algorithmURI = $algorithmURI;
        CipherData cipherData = encData.getCipherData();
        GenericElement cipherValue = cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        byte[] data = null;
        if (cipherValue != null) {
            data = XMLDecryptor.gatherBytes(cipherValue.getDomRepresentation());
        } else {
            CipherReference cipherReference = (CipherReference)cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
            cipherReference.setTransformationFactory(this.trFact);
            data = cipherReference.getReferenced();
        }
        try {
            return this.decrypt1(data);
        }
        catch (SignatureException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SignatureException("Unable to decrypt to octets:  algorithm: " + $algorithmURI + " element: " + el, new Object[]{el, $algorithmURI}, e);
        }
    }

    public String decryptEncData(Node n, String $algorithmURI) throws SignatureException {
        if (n instanceof Element) {
            return this.decryptEncData((Element)n, $algorithmURI);
        }
        if (n instanceof Document) {
            return this.decryptEncData(((Document)n).getDocumentElement(), $algorithmURI);
        }
        throw new SignatureException("Can decrypt Document or Element only!", new Object[]{n, $algorithmURI});
    }

    public String decryptEncData(Element el, String $algorithmURI) throws SignatureException {
        EncryptedData encData = new EncryptedData(el, true);
        encData.initializeDescendants();
        if (this.key != null) {
            encData.setKey(this.key);
        }
        try {
            byte[] ret = encData.getDecrypted();
            if (ret != null) {
                return new String(ret);
            }
        }
        catch (Exception exception) {}
        if ($algorithmURI == null) {
            $algorithmURI = XMLDecryptor.deduceAlgorithm(encData);
        }
        if ($algorithmURI == null) {
            throw new SignatureException("Unable to determine algorithm.", new Object[]{el, $algorithmURI});
        }
        this.algorithmURI = $algorithmURI;
        CipherData cipherData = encData.getCipherData();
        GenericElement cipherValue = cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        if (cipherValue != null) {
            return this.decryptLiteral(cipherValue, $algorithmURI);
        }
        CipherReference cipherReference = (CipherReference)cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        cipherReference.setTransformationFactory(this.trFact);
        return this.decryptReference(cipherReference, $algorithmURI);
    }

    private String decryptLiteral(GenericElement cipherValue, String $algorithmURI) throws SignatureException {
        return this.decrypt((Element)cipherValue.getDomRepresentation(), $algorithmURI);
    }

    private String decryptReference(CipherReference cipherReference, String $algorithmURI) throws SignatureException {
        try {
            byte[] data = cipherReference.getReferenced();
            return this.decrypt0(data);
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error while decrypting reference: algorithm:" + $algorithmURI, new Object[]{cipherReference, $algorithmURI}, e);
        }
    }

    public String decrypt(Element parent, String $algorithmURI) throws SignatureException {
        try {
            this.algorithmURI = $algorithmURI;
            return this.decrypt0(XMLDecryptor.gatherBytes(parent));
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error while decrypting: algorithm: " + $algorithmURI, new Object[]{parent, $algorithmURI}, e);
        }
    }

    public void restoreOriginalContent(Element encData, String $algorithmURI) throws SignatureException {
        Node parent = encData.getParentNode();
        byte[] decrypted = this.decryptToOctets(encData, $algorithmURI);
        String type = encData.getAttribute("Type");
        Node toAdd = null;
        if (this.parseDecrypted) {
            Hashtable mappings = DOM.getNamespaceMappingsInScope(parent);
            if (type == null || type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                byte[] temp1 = new byte[decrypted.length + 7];
                temp1[0] = 60;
                temp1[1] = 97;
                temp1[2] = 62;
                System.arraycopy(decrypted, 0, temp1, 3, decrypted.length);
                int index = temp1.length - 4;
                temp1[index++] = 60;
                temp1[index++] = 47;
                temp1[index++] = 97;
                temp1[index++] = 62;
                Element d = SignatureContext.parse(new ByteArrayInputStream(temp1), mappings).getDocumentElement();
                Document doc = encData.getOwnerDocument();
                DocumentFragment fr = doc.createDocumentFragment();
                NodeList nl = d.getChildNodes();
                int len = nl.getLength();
                int i = 0;
                while (i < len) {
                    fr.appendChild(doc.importNode(nl.item(i).cloneNode(true), true));
                    ++i;
                }
                toAdd = fr;
            } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Document temp = SignatureContext.parse(new ByteArrayInputStream(decrypted), mappings);
                toAdd = temp.getDocumentElement();
            }
            toAdd = parent instanceof Document ? ((Document)parent).importNode(toAdd, true) : parent.getOwnerDocument().importNode(toAdd, true);
        } else {
            toAdd = new BinaryTextImpl((Document)(parent instanceof Document ? parent : parent.getOwnerDocument()));
            toAdd.setBinaryData(decrypted);
        }
        Element oldNode = XMLDecryptor.getChildElementByName(parent, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        Node sibling = oldNode.getNextSibling();
        parent.removeChild(oldNode);
        if (sibling != null) {
            parent.insertBefore(toAdd, sibling);
        } else {
            parent.appendChild(toAdd);
        }
    }

    public void restoreOriginalContent(Element encData) throws SignatureException {
        this.restoreOriginalContent(encData, null);
    }

    public static Node readStreamAsDOM(InputStream in) throws SignatureException {
        try {
            Document document = SignatureContext.getDocumentBuilderFT().parse(in);
            return document.getDocumentElement();
        }
        catch (Exception e) {
            throw new SignatureException("Error reading stream as DOM", new Object[]{in}, e);
        }
    }

    public static Element getChildElementByName(Node n, String localName, String uri) {
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node tempNode = nl.item(i);
            if (tempNode.getNodeType() == 1 && tempNode.getLocalName().equals(localName) && tempNode.getNamespaceURI().equals(uri)) {
                return (Element)tempNode;
            }
            ++i;
        }
        return null;
    }

    public byte[] decryptRaw(byte[] content, String $algorithmURI) throws IOException, GeneralSecurityException, SignatureException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.algorithmURI = $algorithmURI;
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.algorithmURI);
            CustomCipher ciph = (CustomCipher)((Object)reusable);
            int start = ciph.getIVLength();
            this.IV = new byte[start];
            System.arraycopy(content, 0, this.IV, 0, start);
            IvParameterSpec spec = new IvParameterSpec(this.IV);
            ciph.init(2, this.key, spec);
            byte[] byArray = ciph.doFinal(content, start, content.length - start);
            return byArray;
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }
}

