/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.aliases;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolver;
import java.security.Key;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultKeyAliasResolver
implements KeyAliasResolver {
    private static final String NAME = "Default Key Resolver v0.1";
    protected Hashtable keys = new Hashtable();

    @Override
    public Key getKey(String alias) throws SignatureException {
        return (Key)this.keys.get(alias);
    }

    @Override
    public Enumeration getKeyAliases() throws SignatureException {
        return this.keys.keys();
    }

    @Override
    public void removeKey(String alias) throws SignatureException {
        this.keys.remove(alias);
    }

    @Override
    public void addKey(String alias, Key key) throws SignatureException {
        this.keys.put(alias, key);
    }

    @Override
    public boolean contains(String alias) throws SignatureException {
        return this.keys.containsKey(alias);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Key getKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.getKey(name);
    }

    @Override
    public void removeKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.removeKey(name);
    }

    @Override
    public void addKey(Object alias, Key key) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.addKey(name, key);
    }

    @Override
    public boolean contains(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.contains(name);
    }
}

