/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.aliases;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolver;
import java.security.Key;
import java.util.Enumeration;
import java.util.Vector;

public class KeyAliasResolverImpl
implements KeyAliasResolver {
    private static final String NAME = "Key Alias Resolver Implementation v0.1";
    protected Vector keyAliasResolvers = new Vector();

    @Override
    public Key getKey(String alias) throws SignatureException {
        for (KeyAliasResolver temp : this.keyAliasResolvers) {
            try {
                if (!temp.contains(alias)) continue;
                return temp.getKey(alias);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public Enumeration getKeyAliases() throws SignatureException {
        return null;
    }

    @Override
    public void removeKey(String alias) throws SignatureException {
        for (KeyAliasResolver temp : this.keyAliasResolvers) {
            try {
                if (!temp.contains(alias)) continue;
                temp.removeKey(alias);
                return;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void addKey(String alias, Key key) throws SignatureException {
        throw new SignatureException("Use inner resolvers for this operation");
    }

    @Override
    public boolean contains(String alias) throws SignatureException {
        for (KeyAliasResolver temp : this.keyAliasResolvers) {
            try {
                if (!temp.contains(alias)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void addKeyAliasResolver(KeyAliasResolver kar) {
        this.keyAliasResolvers.addElement(kar);
    }

    public void insertKeyAliasResolverAt(KeyAliasResolver kar, int pos) {
        this.keyAliasResolvers.insertElementAt(kar, pos);
    }

    public void removeKeyAliasResolver(int pos) {
        this.keyAliasResolvers.removeElementAt(pos);
    }

    public int countKeyAliasResolvers() {
        return this.keyAliasResolvers.size();
    }

    public Vector getKeyAliasResolverVector() {
        return this.keyAliasResolvers;
    }

    @Override
    public Key getKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.getKey(name);
    }

    @Override
    public void removeKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.removeKey(name);
    }

    @Override
    public void addKey(Object alias, Key key) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.addKey(name, key);
    }

    @Override
    public boolean contains(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.contains(name);
    }
}

