/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;

public class AES_Transporter
extends KeyTransporter {
    static byte[] testIV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90};

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        SignatureException.traceKey("Key for wrapping(AES)", wrapping);
        SignatureException.traceKey("Key to be wrapped(AES)", wrapped);
        Cipher cipher = null;
        try {
            cipher = SignatureContext.getCryptographicPool().getCipherFromPool(Configurator.getCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc").concat("/ECB/NoPadding"));
            cipher.init(1, wrapping);
            byte[] B = new byte[16];
            byte[] encoded = wrapped.getEncoded();
            byte[] result = new byte[encoded.length + 8];
            Arrays.fill(B, 0, 8, (byte)-90);
            if (encoded.length % 8 != 0 || 6 * encoded.length > 255) {
                throw new SignatureException("Not supported wrapping size:" + result.length);
            }
            System.arraycopy(encoded, 0, result, 8, encoded.length);
            int t = 0;
            int N = encoded.length / 8;
            int j = 0;
            block5: while (true) {
                if (j > 5) {
                    System.arraycopy(B, 0, result, 0, 8);
                    SignatureException.traceByte("Result of encryption(AES)", result);
                    byte[] byArray = result;
                    SignatureContext.getCryptographicPool().releaseCipher(cipher);
                    return byArray;
                }
                int startIndex = 8;
                int i = 1;
                while (true) {
                    if (i > N) {
                        ++j;
                        continue block5;
                    }
                    t = (byte)(t + 1);
                    System.arraycopy(result, startIndex, B, 8, 8);
                    cipher.update(B, 0, 16, B, 0);
                    B[7] = (byte)(B[7] ^ t);
                    System.arraycopy(B, 8, result, startIndex, 8);
                    startIndex += 8;
                    ++i;
                }
                break;
            }
        }
        catch (SignatureException sig) {
            try {
                throw sig;
                catch (Exception ex) {
                    throw new SignatureException(ex);
                }
            }
            catch (Throwable throwable) {
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        SignatureException.traceKey("Key for unwrapping(AES)", wrapping);
        SignatureException.traceByte("Wrapped bytes (AES)", wrapped);
        Cipher cipher = null;
        try {
            cipher = SignatureContext.getCryptographicPool().getCipherFromPool(Configurator.getCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc").concat("/ECB/NoPadding"));
            cipher.init(2, wrapping);
            byte[] B = new byte[16];
            byte[] result = new byte[wrapped.length - 8];
            if (result.length % 8 != 0 || 6 * result.length > 255) {
                throw new SignatureException("Not supported wrapping size:" + result.length);
            }
            int N = result.length / 8;
            byte t = (byte)(6 * N);
            System.arraycopy(wrapped, 0, B, 0, 8);
            int j = 5;
            while (j >= 0) {
                int startIndex = 8 * N;
                int i = N;
                while (i > 0) {
                    B[7] = (byte)(B[7] ^ t);
                    System.arraycopy(wrapped, startIndex, B, 8, 8);
                    cipher.update(B, 0, 16, B, 0);
                    System.arraycopy(B, 8, wrapped, startIndex, 8);
                    startIndex -= 8;
                    t = (byte)(t - 1);
                    --i;
                }
                --j;
            }
            int i = 0;
            while (i < 8) {
                if (B[i] != -90) {
                    throw new SignatureException("Unable to unwrap key with algorithm http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Object[]{wrapping.getEncoded(), wrapped});
                }
                ++i;
            }
            System.arraycopy(wrapped, 8, result, 0, result.length);
            SignatureException.traceByte("Result of decryption(AES)", result);
            byte[] byArray = result;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            return byArray;
        }
        catch (SignatureException sig) {
            try {
                throw sig;
                catch (Exception ex) {
                    throw new SignatureException(ex);
                }
            }
            catch (Throwable throwable) {
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                throw throwable;
            }
        }
    }
}

