/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomCipher;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;

public class RSA_1_5_Transporter
extends KeyTransporter {
    static boolean rsa15fallback = Boolean.getBoolean("com.sap.xml.security.rsa15.fallback");

    @Override
    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        SignatureException.traceKey("Key for wrapping(RSA 1.5)", wrapping);
        SignatureException.traceKey("Key to be wrapped(RSA 1.5)", wrapped);
        Reusable reusable = null;
        try {
            byte[] encoded = wrapped.getEncoded();
            reusable = Reusable.getInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            CustomCipher cipher = (CustomCipher)((Object)reusable);
            cipher.init(1, wrapping);
            byte[] encrypted = cipher.doFinal(encoded, 0, encoded.length);
            SignatureException.traceByte("Result of encryption(RSA 1.5)", encrypted);
            byte[] byArray = encrypted;
            return byArray;
        }
        catch (Exception other) {
            throw new SignatureException("Error in unwrapping key with RSA_1_5", other);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    @Override
    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        SignatureException.traceKey("Key for unwrapping(RSA 1.5)", wrapping);
        SignatureException.traceByte("Wrapped bytes (RSA 1.5)", wrapped);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            CustomCipher cipher = (CustomCipher)((Object)reusable);
            cipher.init(2, wrapping);
            byte[] decrypted = cipher.doFinal(wrapped, 0, wrapped.length);
            SignatureException.traceByte("Result of decryption(RSA 1.5)", decrypted);
            byte[] byArray = decrypted;
            return byArray;
        }
        catch (Exception other) {
            if (rsa15fallback) {
                byte[] byArray = this.decryptFallBack(wrapping, wrapped);
                return byArray;
            }
            throw new SignatureException("Error in unwrapping key with RSA_1_5", other);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] decryptFallBack(Key wrapping, byte[] wrapped) throws SignatureException {
        reusable = null;
        try {
            reusable = Reusable.getInstance("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            cipher = (CustomCipher)reusable;
            cipher.init(2, wrapping);
            block = cipher.doFinal(wrapped, 0, wrapped.length);
            start = 0;
            while (block[start] == 0) {
                ++start;
            }
            if (block[start++] == 2) ** GOTO lbl14
            throw new SignatureException("Invalid encrypted key!", new Object[]{wrapping, wrapped});
lbl-1000:
            // 1 sources

            {
                ++start;
lbl14:
                // 2 sources

                ** while (block[start] != 0)
            }
lbl15:
            // 1 sources

            result = new byte[block.length - ++start];
            System.arraycopy(block, start, result, 0, result.length);
            var9_10 = result;
            return var9_10;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error while decrypting", new Object[]{wrapping, wrapped}, e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }
}

