/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class TDES_Transporter
extends KeyTransporter {
    private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        SignatureException.traceKey("Key for wrapping(TDES)", wrapping);
        SignatureException.traceKey("Key to be wrapped(TDES)", wrapped);
        Cipher cipher = null;
        MessageDigest digest = null;
        try {
            cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "CBC", "NoPadding");
            byte[] key = wrapped.getEncoded();
            digest = SignatureContext.getCryptographicPool().getMessageDigestFromPool("http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] digBytes = digest.digest(key);
            byte[] checkSumKey = new byte[key.length + 8];
            System.arraycopy(key, 0, checkSumKey, 0, key.length);
            System.arraycopy(digBytes, 0, checkSumKey, key.length, 8);
            byte[] iv = new byte[8];
            this.randomize(iv);
            IvParameterSpec pSpec = new IvParameterSpec(iv);
            cipher.init(1, wrapping, pSpec);
            byte[] temp1 = cipher.doFinal(checkSumKey);
            byte[] temp2 = new byte[temp1.length + 8];
            System.arraycopy(iv, 0, temp2, 0, 8);
            System.arraycopy(temp1, 0, temp2, 8, temp1.length);
            byte temp = 0;
            int i = 0;
            while (true) {
                if (i >= temp2.length / 2) {
                    pSpec = new IvParameterSpec(IV);
                    cipher.init(1, wrapping, pSpec);
                    byte[] encrypted = cipher.doFinal(temp2);
                    SignatureException.traceByte("Result of encryption(TDES)", encrypted);
                    byte[] byArray = encrypted;
                    SignatureContext.getCryptographicPool().releaseCipher(cipher);
                    SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                    return byArray;
                }
                temp = temp2[i];
                temp2[i] = temp2[temp2.length - i - 1];
                temp2[temp2.length - i - 1] = temp;
                ++i;
            }
        }
        catch (SignatureException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new SignatureException("Error uwrapping key", ex2);
                }
            }
            catch (Throwable throwable) {
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        SignatureException.traceKey("Key for unwrapping(TDES)", wrapping);
        SignatureException.traceByte("Wrapped bytes (TDES)", wrapped);
        Cipher cipher = null;
        MessageDigest digest = null;
        try {
            cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "CBC", "NoPadding");
            IvParameterSpec pSpec = new IvParameterSpec(IV);
            cipher.init(2, wrapping, pSpec);
            byte[] decrypted = cipher.doFinal(wrapped);
            int originalSize = decrypted.length;
            byte temp = 0;
            int i = 0;
            while (i < originalSize / 2) {
                temp = decrypted[i];
                decrypted[i] = decrypted[originalSize - i - 1];
                decrypted[originalSize - i - 1] = temp;
                ++i;
            }
            byte[] iv = new byte[8];
            System.arraycopy(decrypted, 0, iv, 0, 8);
            pSpec = new IvParameterSpec(iv);
            cipher.init(2, wrapping, pSpec);
            decrypted = cipher.doFinal(decrypted, 8, originalSize - 8);
            originalSize = decrypted.length;
            byte[] ret = new byte[originalSize - 8];
            System.arraycopy(decrypted, 0, ret, 0, ret.length);
            digest = SignatureContext.getCryptographicPool().getMessageDigestFromPool("http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] digBytes = digest.digest(ret);
            int i2 = 0;
            while (i2 < 8) {
                if (digBytes[i2] != decrypted[ret.length + i2]) {
                    throw new SignatureException("Key check sum error", new Object[]{ret, digBytes, decrypted});
                }
                ++i2;
            }
            SignatureException.traceByte("Result of decryption(TDES)", ret);
            byte[] byArray = ret;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
            return byArray;
        }
        catch (SignatureException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new SignatureException("Error uwrapping key", ex2);
                }
            }
            catch (Throwable throwable) {
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                throw throwable;
            }
        }
    }
}

