/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.generator;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.Constants;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.crypto.CustomSignature;
import com.sap.engine.lib.xml.signature.crypto.Reusable;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.elements.Object;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.elements.SignedInfo;
import com.sap.engine.lib.xml.signature.elements.XMLSignature;
import com.sap.engine.lib.xml.signature.generator.XMLSigner;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.ExclusiveCanonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureGenerator
implements XMLSigner {
    private boolean showKeyValue = true;
    private String keyName = null;
    private Certificate[] certs = null;
    private Key publicKey = null;
    private Key privateKey = null;
    private String cAlgorithmURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private String signatureAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String idNamespaceURI = null;
    private String idLocalName = "Id";
    public boolean skipConsistencyCheck = false;
    public boolean showKeyInfo = true;
    public static String defaultSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Node parent = null;
    private Vector references = new Vector();
    private Vector objects = new Vector();
    private Vector objectIDs = new Vector();
    private OutputStream out;
    private String digestAlgorithmURI;
    protected XMLSignature signature = null;
    protected SignedInfo sInfo = null;
    protected GenericElement sValue;
    protected boolean generateNewLine = true;
    protected boolean skipPrefixList = true;
    private boolean generateSignature = true;
    public static Hashtable nsMappings = new Hashtable();

    static {
        nsMappings.put("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    public void addReference(String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, null, null);
    }

    @Override
    public void addReference(String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, proxyHost, proxyPort);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(canonicalizationURI, uri, transforms, digestMethod, null, null);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        if (uri == null) {
            uri = "";
        }
        if (!this.skipConsistencyCheck) {
            this.checkConsistency(canonicalizationURI, uri, transforms, digestMethod);
        }
        Reference ref = new Reference();
        ref.setURI(uri);
        ref.setTransforms(transforms);
        ref.setDigestURI(digestMethod);
        ref.setProxy(proxyHost, proxyPort);
        this.references.add(ref);
    }

    @Override
    public void addObject(Node object) {
        this.objects.add(object);
        this.objectIDs.add(null);
    }

    @Override
    public void addObject(Node object, String id) {
        this.objects.add(object);
        this.objectIDs.add(id);
    }

    @Override
    public void setIDAttribute(String localName, String uri) {
        this.idLocalName = localName;
        this.idNamespaceURI = uri;
    }

    @Override
    public void setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signatureAlgorithmURI = signatureAlgorithmURI;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        SignatureException.traceKey("Private key for signing", privateKey);
        this.privateKey = privateKey;
    }

    @Override
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        SignatureException.traceKey("Public key for signing", publicKey);
        this.publicKey = publicKey;
    }

    @Override
    public void setCertificate(Certificate cert) {
        SignatureException.traceCertificate("Setting certificate", cert);
        this.certs = new Certificate[]{cert};
    }

    @Override
    public void setCertificates(Certificate[] certs) {
        SignatureException.traceCertificateArray("Setting certificate ", certs);
        this.certs = certs;
    }

    public void setOutputStream(OutputStream $out) {
        this.out = $out;
    }

    @Override
    public void setDigestAlgorithm(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    @Override
    public void setCanonicalizationAlgorithm(String cAlgorithmURI) {
        this.cAlgorithmURI = cAlgorithmURI;
    }

    @Override
    public void showKeyValue(boolean $showKeyValue) {
        this.showKeyValue = $showKeyValue;
    }

    public static void signDocument(Element parent) throws SignatureException {
        SignatureGenerator.signDocument(parent, null, null, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, Certificate cert) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, null, cert);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, publicKey, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey, Certificate cert) throws SignatureException {
        if (publicKey == null && privateKey == null) {
            KeyPairGenerator gen;
            block6: {
                try {
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("DSA", Configurator.getProviderName());
                        break block6;
                    }
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("RSA", Configurator.getProviderName());
                        break block6;
                    }
                    throw new SignatureException("Unrecognized default signature algorithm: " + defaultSignatureAlgorithm, new java.lang.Object[]{parent, privateKey, publicKey, cert});
                }
                catch (SignatureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SignatureException("Error signing document", new java.lang.Object[]{parent, privateKey, publicKey, cert}, e);
                }
            }
            KeyPair pair = gen.genKeyPair();
            privateKey = pair.getPrivate();
            publicKey = pair.getPublic();
        }
        SignatureGenerator generator = new SignatureGenerator();
        Transformation tr1 = TransformationFactory.newInstance().getInstance("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new Object[]{(Object)((java.lang.Object)parent)});
        generator.setPrivateKey(privateKey);
        generator.setCertificate(cert);
        generator.setPublicKey(publicKey);
        generator.addReference("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "", new Transformation[]{tr1}, "http://www.w3.org/2000/09/xmldsig#sha1");
        generator.generate(parent);
    }

    @Override
    public Node generateHere(Element dummy) throws SignatureException {
        Node localParent = dummy.getParentNode();
        if (localParent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{dummy});
        }
        this.parent = localParent;
        this.signature = new XMLSignature(localParent, dummy, true);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    @Override
    public Node generate(Element $parent) throws SignatureException {
        if ($parent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{$parent});
        }
        this.parent = $parent;
        this.signature = new XMLSignature($parent);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    @Override
    public Node generateBefore(Element sibling) throws SignatureException {
        Node localParent = sibling.getParentNode();
        if (localParent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{sibling});
        }
        this.parent = localParent;
        this.signature = new XMLSignature(localParent, sibling, false);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    private void generate(XMLSignature sig) throws SignatureException {
        try {
            try {
                this.appendObjects(sig);
                this.sInfo = new SignedInfo("http://www.w3.org/2000/09/xmldsig#", String.valueOf(Constants.getSTANDARD_PREFIX()) + "SignedInfo", sig);
                this.sValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", String.valueOf(Constants.getSTANDARD_PREFIX()) + "SignatureValue", sig);
                GenericElement canonURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", String.valueOf(Constants.getSTANDARD_PREFIX()) + "CanonicalizationMethod", this.sInfo);
                GenericElement algURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", String.valueOf(Constants.getSTANDARD_PREFIX()) + "SignatureMethod", this.sInfo);
                canonURI.setAttribute("Algorithm", this.cAlgorithmURI);
                if (!this.skipPrefixList && this.cAlgorithmURI.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                    GenericElement inclusiveNamespaces = new GenericElement("http://www.w3.org/2001/10/xml-exc-c14n#", "c14:InclusiveNamespaces", canonURI);
                    inclusiveNamespaces.setAttribute("PrefixList", "c14");
                }
                algURI.setAttribute("Algorithm", this.signatureAlgorithmURI);
                int i = 0;
                while (i < this.references.size()) {
                    Reference ref = (Reference)this.references.get(i);
                    ref.setEnvelopingElement(this.parent);
                    ref.setIDAttribute(this.idLocalName, this.idNamespaceURI);
                    ref.setSkipPrefixList(this.skipPrefixList);
                    ref.digest(this.sInfo);
                    ++i;
                }
                if (this.generateSignature) {
                    this.sValue.appendTextChild(new String(this.sign(this.sInfo, this.privateKey)));
                }
                if (this.showKeyInfo) {
                    KeyInfo kInfo = new KeyInfo("http://www.w3.org/2000/09/xmldsig#", String.valueOf(Constants.getSTANDARD_PREFIX()) + "KeyInfo", sig);
                    kInfo.setPrivateKey(this.privateKey);
                    kInfo.setPublicKey((PublicKey)this.publicKey);
                    if (this.keyName != null) {
                        kInfo.setKeyName(this.keyName);
                        kInfo.addKeyName();
                    }
                    if (this.certs != null) {
                        kInfo.setCertificates(this.certs);
                        kInfo.addCertificateInfo();
                    }
                    if (this.showKeyValue && (this.publicKey != null || this.certs != null && this.certs.length > 0)) {
                        kInfo.addKeyValue(this.privateKey.getAlgorithm());
                    }
                }
            }
            catch (SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignatureException("Generating signature exception", new java.lang.Object[]{sig}, e);
            }
        }
        finally {
            Constants.removeSTANDARD_PREFIX();
        }
    }

    private byte[] sign(SignedInfo sInfo, Key $privateKey) throws NoSuchAlgorithmException, SignatureException {
        byte[] canonInfo;
        boolean[] commExcl = SignatureGenerator.detCommExcl(this.cAlgorithmURI);
        boolean retainComments = commExcl[0];
        boolean exclusive = commExcl[1];
        if (exclusive) {
            canonInfo = ExclusiveCanonicalization.canonicalize(sInfo.getDomRepresentation(), retainComments, null);
        } else {
            String newSignatureLocator = "ancestor-or-self::ds:SignedInfo and count(ancestor::*/child::node()[name()='ds:SignatureValue'][string()!='']) = 0";
            ByteArrayInputStream is = new ByteArrayInputStream(Canonicalization.canonicalize(sInfo.getOwner(), true));
            canonInfo = XPathTransformation.filterSet(is, newSignatureLocator, nsMappings, retainComments);
        }
        SignatureException.traceByteAsString("Canonicalized signature", canonInfo);
        Reusable reusable = null;
        try {
            reusable = Reusable.getInstance(this.signatureAlgorithmURI);
            CustomSignature sig = (CustomSignature)((java.lang.Object)reusable);
            sig.initSign($privateKey);
            sig.update(canonInfo);
            byte[] xmlSpecific = this.signatureAlgorithmURI.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") ? SignatureGenerator.Asn1toXMLsignture(sig.sign()) : sig.sign();
            SignatureException.traceByte("Signature result", xmlSpecific);
            byte[] byArray = this.generateNewLine ? BASE64Encoder.encode(xmlSpecific) : BASE64Encoder.encodeN(xmlSpecific);
            return byArray;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Error while signing", new java.lang.Object[]{sInfo, $privateKey}, e);
        }
        finally {
            if (reusable != null) {
                reusable.release();
            }
        }
    }

    private void appendObjects(XMLSignature sig) throws SignatureException {
        int i = 0;
        while (i < this.objects.size()) {
            Object o = new Object(sig);
            o.getDomRepresentation().appendChild(((Node)this.objects.get(i)).cloneNode(true));
            String id = (String)this.objectIDs.get(i);
            if (id != null) {
                if (this.idNamespaceURI == null) {
                    ((Element)o.getDomRepresentation()).setAttribute("Id", (String)this.objectIDs.get(i));
                } else {
                    Hashtable nsMappingsLocal = DOM.getNamespaceMappingsInScopeSpecial(o.getDomRepresentation());
                    Enumeration keys = nsMappingsLocal.keys();
                    while (keys.hasMoreElements()) {
                        String nextPrefix = (String)keys.nextElement();
                        String nextUri = (String)nsMappingsLocal.get(nextPrefix);
                        if (!nextUri.equals(this.idNamespaceURI)) continue;
                        ((Element)o.getDomRepresentation()).setAttributeNS(nextUri, String.valueOf(nextPrefix) + ":" + nextUri, (String)this.objectIDs.get(i));
                    }
                }
            }
            ++i;
        }
    }

    public static boolean[] detCommExcl(String canonURI) throws SignatureException {
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(canonURI)) {
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            return blArray;
        }
        if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(canonURI)) {
            return new boolean[]{true, true};
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(canonURI)) {
            boolean[] blArray = new boolean[2];
            blArray[0] = true;
            return blArray;
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(canonURI)) {
            return new boolean[2];
        }
        throw new SignatureException("Unrecognized canonicalization method uri : " + canonURI, new java.lang.Object[]{canonURI});
    }

    private void checkConsistency(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        if (!"".equals(uri) && !uri.startsWith("#")) {
            int i = 0;
            while (i < transforms.length) {
                if (transforms[i].uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                    throw new SignatureException("Enveloped signatures can be done only on same-document references.", new java.lang.Object[]{canonicalizationURI, uri, transforms, digestMethod});
                }
                ++i;
            }
        }
        if ("".equals(uri) && transforms.length < 1) {
            throw new SignatureException("An empty uri (same document) reference without a transformation would surely be invalid!", new java.lang.Object[]{canonicalizationURI, uri, transforms, digestMethod});
        }
    }

    private static byte[] Asn1toXMLsignture(byte[] asn1Octets) throws SignatureException {
        int sLength;
        int rLength;
        int i = rLength = asn1Octets[3];
        while (i > 0 && asn1Octets[4 + rLength - i] == 0) {
            --i;
        }
        int j = sLength = asn1Octets[5 + rLength];
        while (j > 0 && asn1Octets[6 + rLength + sLength - j] == 0) {
            --j;
        }
        if (asn1Octets[0] != 48 || asn1Octets[1] != asn1Octets.length - 2 || asn1Octets[2] != 2 || i > 20 || asn1Octets[4 + rLength] != 2 || j > 20) {
            throw new SignatureException("Invalid format for DSA", new java.lang.Object[]{asn1Octets});
        }
        byte[] signatureOctets = new byte[40];
        System.arraycopy(asn1Octets, 4 + rLength - i, signatureOctets, 20 - i, i);
        System.arraycopy(asn1Octets, 6 + rLength + sLength - j, signatureOctets, 40 - j, j);
        return signatureOctets;
    }

    public void setSharedKey(Key sharedKey) {
        this.publicKey = sharedKey;
        this.privateKey = sharedKey;
    }

    public boolean isPrefixListAdded() {
        return !this.skipPrefixList;
    }

    public void addPrefixList(boolean addPrefixList) {
        this.skipPrefixList = !addPrefixList;
    }

    public Node sign() throws NoSuchAlgorithmException, SignatureException {
        if (this.generateSignature) {
            throw new SignatureException("Document already signed");
        }
        this.sValue.appendTextChild(new String(this.sign(this.sInfo, this.privateKey)));
        return this.signature.getDomRepresentation();
    }

    public boolean isGenerateSignature() {
        return this.generateSignature;
    }

    public void setGenerateSignature(boolean generateSignature) {
        this.generateSignature = generateSignature;
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public boolean isGenerateNewLine() {
        return this.generateNewLine;
    }

    public void setGenerateNewLine(boolean generateNewLine) {
        this.generateNewLine = generateNewLine;
    }
}

