/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransformationFactory {
    public HashMap dataHashmap = new HashMap();
    public Vector customTransforms = new Vector();

    public static TransformationFactory newInstance() {
        return new TransformationFactory();
    }

    protected TransformationFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransformation(Transformation tr) {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            if (!this.customTransforms.contains(tr)) {
                this.customTransforms.add(tr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformation getInstance(String uri, Object[] additionalArgs) throws SignatureException {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            int length = this.customTransforms.size();
            int i = 0;
            while (i < length) {
                Transformation next = (Transformation)this.customTransforms.get(i);
                if (uri.equals(next.uri)) {
                    Transformation cloned = next.defineFrom(additionalArgs, this.dataHashmap);
                    return cloned;
                }
                ++i;
            }
        }
        return Transformation.getInstance(uri, additionalArgs);
    }

    public Transformation getInstance(GenericElement e) throws SignatureException {
        Transformation custom = this.getCustom(e);
        if (custom != null) {
            return custom;
        }
        String uri = e.getAttribute("Algorithm", null, null);
        if (uri == null) {
            throw new SignatureException("Attribute \"Algorithm \" not found on element " + ((Element)e.getDomRepresentation()).getLocalName(), new Object[]{e});
        }
        Object[] additionalArgs = null;
        if (uri.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            GenericElement xpath = e.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "XPath");
            String query = xpath.getNodeValue();
            Hashtable mappings = xpath.getNamespaceMappingsInScope();
            additionalArgs = new Object[]{query, mappings};
        } else if (uri.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            Hashtable attribs;
            String prefixList;
            GenericElement inclusiveNamespaces = e.getDirectChild("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
            if (inclusiveNamespaces != null && (prefixList = (String)(attribs = inclusiveNamespaces.getAttributes()).get("PrefixList")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(prefixList);
                String[] iN = new String[tokenizer.countTokens()];
                int i = 0;
                while (i < iN.length) {
                    iN[i] = tokenizer.nextToken();
                    ++i;
                }
                additionalArgs = new Object[]{iN};
            }
        } else if (uri.startsWith("http://www.w3.org/2002/07/decrypt#")) {
            Element el = (Element)e.getDomRepresentation();
            NodeList except = el.getElementsByTagNameNS("http://www.w3.org/2002/07/decrypt#", "Except");
            additionalArgs = new Object[except.getLength()];
            int i = 0;
            while (i < additionalArgs.length) {
                additionalArgs[i] = ((Element)except.item(i)).getAttribute("URI");
                ++i;
            }
        } else if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(uri)) {
            additionalArgs = new Object[]{e.getDomRepresentation()};
        }
        return this.getInstance(uri, additionalArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformation getCustom(GenericElement ge) throws SignatureException {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            int length = this.customTransforms.size();
            int i = 0;
            while (i < length) {
                Transformation next = (Transformation)this.customTransforms.get(i);
                Transformation cloned = next.defineFrom(ge, this.dataHashmap);
                if (cloned != null) {
                    return cloned;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, Object value) {
        HashMap hashMap = this.dataHashmap;
        synchronized (hashMap) {
            this.dataHashmap.put(key, value);
        }
    }
}

