/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.signature.transform.algorithms.PooledByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.Vector;

public class ByteArrayOutputStreamPool {
    protected Vector freePool = new Vector(100, 100);
    protected int MAX_COUNT = 400;
    protected int MAX_POOLED_SIZE = 7000000;
    protected long MAX_POOL_SIZE = 10000000L;
    protected long currentPoolSize = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(PooledByteArrayOutputStream enc) {
        Vector vector = this.freePool;
        synchronized (vector) {
            if (this.MAX_POOL_SIZE != 0L && this.currentPoolSize > this.MAX_POOL_SIZE) {
                this.releaseAll();
            }
            if (this.freePool.size() < this.MAX_COUNT && (this.MAX_POOLED_SIZE == 0 || enc.getLength() < (long)this.MAX_POOLED_SIZE)) {
                this.freePool.addElement(enc);
                this.currentPoolSize += enc.getLength();
            }
        }
    }

    public int getMaxCount() {
        return this.MAX_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCount(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("No negative pool size allowed!:" + value);
        }
        Vector vector = this.freePool;
        synchronized (vector) {
            int k;
            while (value < (k = this.freePool.size())) {
                this.freePool.removeElementAt(k - 1);
            }
        }
        this.MAX_COUNT = value;
        this.recalculateSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalculateSize() {
        Vector vector = this.freePool;
        synchronized (vector) {
            this.currentPoolSize = 0L;
            int i = 0;
            while (i < this.freePool.size()) {
                this.currentPoolSize += ((PooledByteArrayOutputStream)this.freePool.elementAt(i)).getLength();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        Vector vector = this.freePool;
        synchronized (vector) {
            this.freePool.clear();
            this.currentPoolSize = 0L;
        }
    }

    public int getMaxPooledSize() {
        return this.MAX_POOLED_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPooledSize(int maxPooledSize) {
        if (this.MAX_POOL_SIZE < 0L) {
            throw new IllegalArgumentException("Max Pooled Element Size cannot be less than 0:" + maxPooledSize);
        }
        Vector vector = this.freePool;
        synchronized (vector) {
            this.MAX_POOLED_SIZE = maxPooledSize;
            Iterator iter = this.freePool.iterator();
            while (iter.hasNext()) {
                PooledByteArrayOutputStream temp = (PooledByteArrayOutputStream)iter.next();
                if (maxPooledSize == 0 || temp.getLength() <= (long)maxPooledSize) continue;
                iter.remove();
                this.currentPoolSize -= temp.getLength();
            }
        }
    }

    public long getMaxPoolSize() {
        return this.MAX_POOL_SIZE;
    }

    public void setMaxPoolSize(long maxPoolSize) {
        if (maxPoolSize < 0L) {
            throw new IllegalArgumentException("Max Pool Size cannot be less than 0:" + maxPoolSize);
        }
        if (maxPoolSize != 0L && maxPoolSize < this.MAX_POOL_SIZE) {
            this.releaseAll();
        }
        this.MAX_POOL_SIZE = maxPoolSize;
    }

    public long getCurrentPoolSize() {
        return this.currentPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getInstance() {
        PooledByteArrayOutputStream stream;
        Vector vector = this.freePool;
        synchronized (vector) {
            int size = this.freePool.size();
            if (size > 0) {
                stream = (PooledByteArrayOutputStream)this.freePool.remove(size - 1);
                this.currentPoolSize -= stream.getLength();
            } else {
                stream = new PooledByteArrayOutputStream(this);
            }
        }
        return stream;
    }
}

