/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Canonicalization
extends Transformation {
    private boolean commented = false;

    public Canonicalization(Object[] args, boolean commented) {
        super(args);
        this.commented = commented;
        this.uri = commented ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public Canonicalization(boolean commented) {
        this(null, commented);
    }

    private Node canonicalize0(Node n) throws SignatureException {
        Document document;
        CanonicalDocHandlerSerializer cdhs = null;
        try {
            Document document2;
            ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            cdhs = Canonicalization.get(baos, SignatureContext.getProperties());
            cdhs.retainComments(this.commented);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            SignatureContext.getTransformer().transform(source, result);
            byte[] resOctets = baos.toByteArray();
            SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
            InputSource is = new InputSource(new ByteArrayInputStream(resOctets));
            document = document2 = SignatureContext.getDocumentBuilderTT().parse(is);
        }
        catch (Exception e) {
            try {
                throw new SignatureException("Exception while canonicalizing " + n.toString(), new Object[]{n}, e);
            }
            catch (Throwable throwable) {
                Canonicalization.release(cdhs);
                throw throwable;
            }
        }
        Canonicalization.release(cdhs);
        return document;
    }

    private byte[] octeticalizeOmitting(Node n) throws SignatureException {
        return Canonicalization.canonicalize(n, false);
    }

    private byte[] octeticalizeIncluding(Node n) throws SignatureException {
        return Canonicalization.canonicalize(n, true);
    }

    public void retainComments(boolean $commented) {
        this.commented = $commented;
    }

    public static Node canonicalizeToNode(byte[] input, boolean retainComments) throws SignatureException {
        try {
            input = Canonicalization.canonicalize(input, retainComments);
            return SignatureContext.getDocumentBuilderTT().parse(new ByteArrayInputStream(input));
        }
        catch (Exception e) {
            throw new SignatureException("Error while canonicalizing to node", new Object[]{input}, e);
        }
    }

    public static byte[] canonicalize(Node n, boolean retainComments) throws SignatureException {
        byte[] byArray;
        CanonicalDocHandlerSerializer cdhs = null;
        try {
            ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            cdhs = Canonicalization.get(baos, SignatureContext.getProperties());
            cdhs.retainComments(retainComments);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            SignatureContext.getTransformer().transform(source, result);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SignatureException("Exception while canonicalizing " + n.toString(), new Object[]{n}, e);
            }
            catch (Throwable throwable) {
                Canonicalization.release(cdhs);
                throw throwable;
            }
        }
        Canonicalization.release(cdhs);
        return byArray;
    }

    public static byte[] canonicalize(byte[] input, boolean retainComments) throws SignatureException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return Canonicalization.canonicalize(bais, retainComments);
    }

    public static byte[] canonicalize(InputStream input, boolean retainComments) throws SignatureException {
        byte[] byArray;
        CanonicalDocHandlerSerializer cdhs = null;
        try {
            ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            cdhs = Canonicalization.get(baos, SignatureContext.getProperties());
            cdhs.retainComments(retainComments);
            XMLParser parser = new XMLParser();
            parser.setEntityResolver(SignatureContext.getEntityResolver());
            parser.parse(input, (DocHandler)cdhs);
            byArray = baos.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SignatureException("Exception while canonicalization", new Object[]{input}, e);
            }
            catch (Throwable throwable) {
                Canonicalization.release(cdhs);
                throw throwable;
            }
        }
        Canonicalization.release(cdhs);
        return byArray;
    }

    public byte[] transformToOctets(Node n) throws SignatureException {
        if (!this.commented) {
            return this.octeticalizeOmitting(n);
        }
        return this.octeticalizeIncluding(n);
    }

    public Node transform(Node n) throws SignatureException {
        return this.canonicalize0(n);
    }

    @Override
    public void transform(Data d) throws SignatureException {
        d.setOctets(Canonicalization.canonicalize(d.getOctets(), this.commented));
    }

    @Override
    public Transformation defineFrom(GenericElement el, HashMap $dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: Canonicalization!", new Object[]{el, $dataHashmap});
    }

    public static void release(CanonicalDocHandlerSerializer cdhs) {
        SignatureContext.getCanonicalizationPool().release(cdhs);
    }

    public static CanonicalDocHandlerSerializer get(ByteArrayOutputStream baos, Properties properties) throws OutputException {
        return SignatureContext.getCanonicalizationPool().get(baos, properties);
    }
}

