/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EvelopedSignatureTransformation
extends Transformation {
    Element currentElement;
    String idAttribute = "ID";

    public EvelopedSignatureTransformation(Object[] additionalArgs) {
        super(additionalArgs);
        if (additionalArgs != null && additionalArgs.length > 0) {
            this.currentElement = (Element)additionalArgs[0];
            if (additionalArgs.length > 1) {
                this.idAttribute = (String)additionalArgs[1];
            }
        }
    }

    @Override
    public Transformation defineFrom(GenericElement el, HashMap hashmap) throws SignatureException {
        this.currentElement = (Element)el.getDomRepresentation();
        return this;
    }

    @Override
    public void transform(Data data) throws SignatureException {
        Node n;
        Element reference;
        Node transforms;
        String referencedUri = null;
        if (this.currentElement != null && "Transform".equals(this.currentElement.getLocalName()) && (transforms = this.currentElement.getParentNode()) != null && (reference = (Element)transforms.getParentNode()) != null) {
            referencedUri = reference.getAttribute("URI");
        }
        if ((n = data.getNode()) instanceof Document) {
            n = ((Document)n).getDocumentElement();
        }
        if (n != null) {
            Node signatureParent;
            Node signature;
            Node signedInfo;
            if (referencedUri == null) {
                NamedNodeMap list = n.getAttributes();
                int i = 0;
                while (i < list.getLength()) {
                    Attr at = (Attr)list.item(i);
                    if (this.idAttribute.equalsIgnoreCase(at.getLocalName())) {
                        referencedUri = "#".concat(at.getValue());
                        break;
                    }
                    ++i;
                }
            }
            if (referencedUri == null) {
                referencedUri = "";
            }
            if ((reference = DOM.getElementByAttribute(n, "URI", null, referencedUri)) != null && (signedInfo = reference.getParentNode()) != null && (signature = signedInfo.getParentNode()) != null && (signatureParent = signature.getParentNode()) != null) {
                NodeList list = signatureParent.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Element el;
                    Node item = list.item(i);
                    if (item instanceof Element && "http://www.w3.org/2000/09/xmldsig#".equals((el = (Element)item).getNamespaceURI()) && "Signature".equals(el.getLocalName())) {
                        signatureParent.removeChild(el);
                    }
                    ++i;
                }
                data.setNode(n);
            }
        }
    }
}

